/*
 * Decompiled with CFR 0.152.
 */
package com.example.autorefresh;

import com.example.autorefresh.IScanner;
import com.example.autorefresh.ISearch;
import com.example.autorefresh.ISearchListener;
import com.example.autorefresh.internal.AutoRefreshSearch;
import com.example.autorefresh.internal.DefaultScanner;
import com.example.autorefresh.internal.PathComparator;
import com.example.autorefresh.internal.Refresher;
import com.example.autorefresh.internal.SearchEngine;
import com.example.autorefresh.internal.SearchManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;

public class AutoRefreshPlugin
extends Plugin {
    private static AutoRefreshPlugin fDefault;
    private SearchManager fSearchManager;
    private SearchEngine fSearchEngine;
    private List fSearches;
    private SortedMap fScanners;
    private IScanner fDefaultScanner;
    private Set fSearchListeners;
    private boolean fIsAutoSearching;
    private boolean fIsAutoRefreshing;
    private long fSearchDelay;
    private static final String PROP_AUTO_SEARCH = "auto.search";
    private static final String PROP_AUTO_REFRESH = "auto.refresh";
    private static final String PROP_SEARCH_DELAY = "search.delay";
    public static final long DEFAULT_SEARCH_DELAY = 60000L;
    public final String PROPERTY_FILE = "prop.ini";

    public AutoRefreshPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fDefault = this;
        this.fSearchListeners = new HashSet(5);
        this.fSearches = new ArrayList(5);
        this.fScanners = new TreeMap(new PathComparator());
        this.fDefaultScanner = new DefaultScanner();
        this.fIsAutoRefreshing = true;
        this.fIsAutoSearching = true;
        this.fSearchDelay = 60000L;
    }

    public static AutoRefreshPlugin getDefault() {
        return fDefault;
    }

    public void startup() throws CoreException {
        this.loadProperties();
        this.changeRunLevel();
    }

    public void shutdown() throws CoreException {
        this.saveProperties();
        this.stopAutoSearch();
        if (this.fSearchEngine != null) {
            this.fSearchEngine.shutdown();
            this.fSearchEngine = null;
        }
    }

    public void registerScanner(IPath path, IScanner scanner) {
        if (path != null && scanner != null) {
            this.fScanners.put(path, scanner);
        }
    }

    public void unregisterScanner(IPath path) {
        if (path != null) {
            this.fScanners.remove(path);
        }
    }

    public IScanner getScanner(IResource resource) {
        if (resource == null) {
            return null;
        }
        IPath path = resource.getLocation();
        Iterator i = this.fScanners.keySet().iterator();
        while (i.hasNext()) {
            IPath root = (IPath)i.next();
            if (!root.isPrefixOf(path)) continue;
            return (IScanner)this.fScanners.get(root);
        }
        return this.fDefaultScanner;
    }

    public void addSearchListener(ISearchListener listener) {
        if (listener != null) {
            this.fSearchListeners.add(listener);
        }
    }

    public void removeSearchListener(ISearchListener listener) {
        if (listener != null) {
            this.fSearchListeners.remove(listener);
        }
    }

    public ISearch createSearch(IResource[] resources) {
        return new AutoRefreshSearch(resources);
    }

    public void search(ISearch search) {
        if (search == null || !(search instanceof AutoRefreshSearch)) {
            return;
        }
        AutoRefreshSearch s = (AutoRefreshSearch)search;
        if (this.isAutoSearching()) {
            this.fSearchManager.search(s);
        } else if (this.fSearchEngine == null || !this.fSearchEngine.isRunning()) {
            this.fSearchEngine = new SearchEngine(s);
            Thread t = new Thread((Runnable)this.fSearchEngine, "Search engine");
            t.start();
        } else {
            this.fSearchEngine.search(s);
        }
    }

    public void refresh(IProgressMonitor monitor) {
        if (!this.fSearches.isEmpty()) {
            List searches;
            List list = this.fSearches;
            synchronized (list) {
                searches = this.fSearches;
                this.fSearches = new ArrayList(5);
            }
            new Refresher().refresh(monitor, searches);
        }
    }

    public boolean hasSearchesToRefresh() {
        return !this.fSearches.isEmpty();
    }

    public boolean isAutoSearching() {
        return this.fIsAutoSearching;
    }

    public void setAutoSearching(boolean searching) {
        if (this.fIsAutoSearching != searching) {
            this.fIsAutoSearching = searching;
            this.changeRunLevel();
        }
    }

    public boolean isAutoRefreshing() {
        return this.fIsAutoRefreshing;
    }

    public void setAutoRefreshing(boolean refreshing) {
        if (this.fIsAutoRefreshing != refreshing) {
            this.fIsAutoRefreshing = refreshing;
            this.changeRunLevel();
        }
    }

    public long getSearchDelay() {
        return this.fSearchDelay;
    }

    public void setSearchDelay(long delay) {
        if (delay <= 0L) {
            delay = 60000L;
        }
        if (this.fSearchDelay != delay) {
            this.fSearchDelay = delay;
        }
    }

    public void searchComplete(AutoRefreshSearch search) {
        if (!search.isEmpty()) {
            this.fSearches.add(search);
            if (this.isAutoRefreshing()) {
                this.refresh(null);
            }
        }
        this.fireSearchComplete(search);
    }

    private void fireSearchComplete(ISearch search) {
        if (this.fSearchListeners.isEmpty()) {
            return;
        }
        Iterator i = this.fSearchListeners.iterator();
        while (i.hasNext()) {
            ((ISearchListener)i.next()).searchComplete(search);
        }
    }

    private void changeRunLevel() {
        if (this.isAutoSearching()) {
            this.startAutoSearch();
        } else {
            this.stopAutoSearch();
        }
    }

    private void startAutoSearch() {
        if (this.isAutoSearching() && this.fSearchManager == null) {
            this.fSearchManager = new SearchManager();
            Thread t = new Thread((Runnable)this.fSearchManager, "Search Manager");
            t.start();
        }
    }

    private void stopAutoSearch() {
        if (this.fSearchManager != null) {
            this.fSearchManager.shutdown();
            this.fSearchManager = null;
        }
    }

    private void loadProperties() {
        File file = this.getPropertyFile();
        Properties properties = new Properties();
        if (file.exists()) {
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(file);
                    properties.load(in);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            Object var6_7 = null;
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.setAutoRefreshing(this.getBoolean(properties, PROP_AUTO_REFRESH, true));
        this.setAutoSearching(this.getBoolean(properties, PROP_AUTO_SEARCH, true));
        this.setSearchDelay(this.getLong(properties, PROP_SEARCH_DELAY, 60000L));
    }

    private void saveProperties() {
        block10: {
            Properties properties = new Properties();
            ((Hashtable)properties).put(PROP_AUTO_REFRESH, Boolean.toString(this.isAutoRefreshing()));
            ((Hashtable)properties).put(PROP_AUTO_SEARCH, Boolean.toString(this.isAutoSearching()));
            ((Hashtable)properties).put(PROP_SEARCH_DELAY, Long.toString(this.getSearchDelay()));
            FileOutputStream out = null;
            try {
                try {
                    out = new FileOutputStream(this.getPropertyFile());
                    properties.store(out, "Auto Refresh Plugin Properties");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            Object var5_7 = null;
            if (out == null) break block10;
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean getBoolean(Properties properties, String key, boolean defaultValue) {
        String p;
        if (properties != null && (p = properties.getProperty(key)) != null && p.length() > 0) {
            return new Boolean(p);
        }
        return defaultValue;
    }

    private long getLong(Properties properties, String key, long defaultValue) {
        String p;
        if (properties != null && (p = properties.getProperty(key)) != null && p.length() > 0) {
            return Long.parseLong(p);
        }
        return defaultValue;
    }

    private File getPropertyFile() {
        IPath propertiesPath = AutoRefreshPlugin.getDefault().getStateLocation().append("prop.ini");
        return propertiesPath.toFile();
    }
}

