package collapsivebuttonsnipped;

import org.eclipse.nebula.widgets.collapsiblebuttons.CollapsibleButtons;
import org.eclipse.nebula.widgets.collapsiblebuttons.DefaultColorManager;
import org.eclipse.nebula.widgets.collapsiblebuttons.DefaultSettings;
import org.eclipse.nebula.widgets.collapsiblebuttons.IColorManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;

public class NavigatorView extends ViewPart {

    final static public String ID = "CollapsiveButtonSnipped.navigatorView"; //$NON-NLS-1$

    private Composite navigationArea;

    private CollapsibleButtons collapsibleButtons;

    public void createPartControl(Composite composite) {

	final GridLayout gridLayout = new GridLayout();
	gridLayout.marginHeight = 0;
	gridLayout.verticalSpacing = 0;
	gridLayout.marginWidth = 0;
	composite.setLayout(gridLayout);

	this.navigationArea = new Composite(composite, SWT.NONE);
	navigationArea.setLayout(new StackLayout());
	final GridData gd_itemArea = new GridData(SWT.FILL, SWT.FILL, true,
		true);
	navigationArea.setLayoutData(gd_itemArea);

	collapsibleButtons = new CollapsibleButtons(composite, SWT.NONE,
		IColorManager.SKIN_AUTO_DETECT, new DefaultColorManager(),
		new DefaultSettings() {
		    @Override
		    public int getToolBarSpacing() {
			return 20;
		    }
		});
	collapsibleButtons.setLayoutData(new GridData(SWT.FILL, SWT.BOTTOM,
		true, false));

	collapsibleButtons.addButton("Button1", "Button1", Activator
		.getImageDescriptor("icons/alt_window_32.gif").createImage(),
		Activator.getImageDescriptor("icons/alt_window_16.gif")
			.createImage());
	collapsibleButtons.addButton("Button2", "Button2", Activator
		.getImageDescriptor("icons/alt_window_32.gif").createImage(),
		Activator.getImageDescriptor("icons/alt_window_16.gif")
			.createImage());
	collapsibleButtons.addButton("Button3", "Button3", Activator
		.getImageDescriptor("icons/alt_window_32.gif").createImage(),
		Activator.getImageDescriptor("icons/alt_window_16.gif")
			.createImage());
	collapsibleButtons.addButton("Button4", "Button4", Activator
		.getImageDescriptor("icons/alt_window_32.gif").createImage(),
		Activator.getImageDescriptor("icons/alt_window_16.gif")
			.createImage());

    }

    @Override
    public void setFocus() {
	// TODO Auto-generated method stub

    }

    public void refreshButton() {
	// TODO Auto-generated method stub
	collapsibleButtons.layout();
    }

}
