package collapsivebuttonsnipped;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor extends WorkbenchWindowAdvisor {

    public ApplicationWorkbenchWindowAdvisor(
	    IWorkbenchWindowConfigurer configurer) {
	super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(
	    IActionBarConfigurer configurer) {
	return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
	IWorkbenchWindowConfigurer configurer = getWindowConfigurer();
	configurer.setInitialSize(new Point(400, 300));
	configurer.setShowCoolBar(false);
	configurer.setShowPerspectiveBar(true);
	configurer.setShowStatusLine(false);
	configurer.setTitle("Hello RCP");
    }

    @Override
    public void postWindowOpen() {
	// TODO Auto-generated method stub
	super.postWindowOpen();
	final NavigatorView navigator = (NavigatorView) PlatformUI
		.getWorkbench().getActiveWorkbenchWindow().getActivePage()
		.findView(NavigatorView.ID);
	Display.getDefault().syncExec(new Runnable() {
	    public void run() {
		if (navigator != null) {
		    navigator.refreshButton();
		}
	    }
	});
    }

}
