#include <assert.h>
#include <errno.h>
#include "mqtt.h"
#include <net/if.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include "mosquitto_broker_internal.h"
#include <netdb.h>
#include <pthread.h>
#include <sys/prctl.h>

static int g_sn_mqtt = -1;
static int g_sn_http = -1;
static char g_sn_mqttS_ip[20] = "127.0.0.1";
#define MQTT_HEART_BEAT_INTERVAL 90
#define MAX_PUSHDATA_LEN (1024*2)
#define MAX_MQTTID_LEN 23

int my_gethostbyname(const char *host, char *ip)
{
	if (host == NULL || ip == NULL) {
		fprintf(stderr, "parameter error\r\n");
		return -1;
	}
	struct addrinfo hints;
	struct addrinfo *result;
	int s;
	memset(&hints, 0, sizeof(struct addrinfo));
	hints.ai_family = AF_UNSPEC;	/* Allow IPv4 or IPv6 */
	hints.ai_socktype = SOCK_DGRAM; /* Datagram socket */
	hints.ai_flags = 0;
	hints.ai_protocol = 0;		  /* Any protocol */
	s = getaddrinfo(host, NULL, &hints, &result);
	if (s != 0) {
		fprintf(stderr, "getaddrinfo: %s\n", gai_strerror(s));
		return -1;
	} else {
		strcpy(ip, inet_ntoa(*((struct in_addr*)&((struct sockaddr_in*)(result->ai_addr))->sin_addr.s_addr)));
		return 0;
	}
}

int is_ip_addr(const char * addr_in)
{
    if(addr_in==NULL)
    {
        return 0;
    }
    uint32_t myip = 0;
    myip = inet_addr((char *)addr_in);
    if(myip == 0 || myip==((uint32_t)-1) )
    {
        return 0;
    }
    return 1;
}


static int self_getdata(uint8_t* buf, int count)
{
	if(count == 0) {
		return 0;
	}
	return recv(g_sn_mqtt, buf, count, 0);
}


// init g_sn_mqtt socket
static int initMqtt()
{
    int flags = 0;
	g_sn_mqtt = socket(AF_INET, SOCK_STREAM, 0);
	if(g_sn_mqtt < 0) {
		mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP g_sn_mqtt<0 in function[%s] line[%d]\r\n", __FUNCTION__, __LINE__);
		flags = 1;
	}
#if 0 
    if((flags = fcntl(g_sn_mqtt, F_GETFL, 0)) < 0) {
        mosquitto_log_printf(MOSQ_LOG_NOTICE,  "Netwrok test...\n");
        flags = 1;
    } else if(fcntl(g_sn_mqtt, F_SETFL, flags | O_NONBLOCK) < 0) {
        flags = 1;
	//mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP function[%s] line[%d] fd[%d]\r\n", __FUNCTION__, __LINE__, g_sn_mqtt);
    }
#endif

	return 0;
}
//todo:config
char g_sn_CloudAddr[CLOUD_ADDR_LEN]= {0};
int g_sn_Cloud_Port = 0;
static char g_sn_CloudAddrIP[20] = "";
// connect to cloud server
static int initHttpAndCon()
{
	int flags = 0;
    	static struct sockaddr_in addr;
	if (strlen(g_sn_CloudAddrIP) == 0) {
		if(is_ip_addr(g_sn_CloudAddr) != 1) {
			int iTurn = 0;
                	while(0 != my_gethostbyname(g_sn_CloudAddr, g_sn_CloudAddrIP)) {
                    		mosquitto_log_printf(MOSQ_LOG_NOTICE,  " cloud gethostbyname error for host:%s \n", g_sn_CloudAddr);
                    		if(iTurn++ > 10) {
                        		mosquitto_log_printf(MOSQ_LOG_NOTICE,  " cloud gethostbyname error iTurn[%d] \n", iTurn);
                        		break;
                    		}
                    		sleep(1);
                    		continue;
                	}
        	} else {
            		strncpy(g_sn_CloudAddrIP, g_sn_CloudAddr, sizeof(g_sn_CloudAddrIP)-1);
        	}
	}

	addr.sin_family = AF_INET;
	addr.sin_port = htons(g_sn_Cloud_Port);
	addr.sin_addr.s_addr = inet_addr(g_sn_CloudAddrIP);
 
#if 1 
	g_sn_http = socket(AF_INET, SOCK_STREAM, 0);
	if(g_sn_http  < 0) {
		mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP g_sn_http < 0 in function[%s] line[%d]\r\n", __FUNCTION__, __LINE__);
		flags = 1;
	}
    
#if 0
	if((flags = fcntl(g_sn_http, F_GETFL, 0)) < 0) {
        	flags = 1;
	} else if(fcntl(g_sn_http, F_SETFL, flags | O_NONBLOCK) < 0) {
		flags = 1;
	} 
#endif

	if(connect(g_sn_http, (struct sockaddr *)&addr, sizeof(addr)) != 0) {
        	if(errno != EINPROGRESS) { // EINPROGRESS 
            		flags = 1;
        	}
        
    	}
	//mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP function[%s] line[%d] g_sn_http[%d]\r\n", __FUNCTION__, __LINE__, g_sn_mqtt);
#endif
	return flags;
}

//connect to mqtt server
static int connectWithMqttS(const char *host, int port, int keepalive)
{
	MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
	uint8_t buf[200];
	int buflen = sizeof(buf);
	int len = 0;
	static struct sockaddr_in addr;

	if(is_ip_addr(host) == 1) {
		strcpy(g_sn_mqttS_ip, host);
	} else {
		 int iTurn = 0;	
			while(0 != my_gethostbyname(host, g_sn_mqttS_ip)) {
				mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP gethostbyname error for host:%s \n", host);
				if (iTurn++ > 10) {
					mosquitto_log_printf(MOSQ_LOG_NOTICE,  "mqtt gethostbyname error iTurn[%d] \n", iTurn);				
					break;
				}
				sleep(1);
				continue;
			}
	
	}
	addr.sin_family = AF_INET;
	addr.sin_port = htons(port);
	addr.sin_addr.s_addr = inet_addr(g_sn_mqttS_ip);

	if(is_ip_addr(host) == 1) {
		addr.sin_addr.s_addr = inet_addr(g_sn_mqttS_ip);
	}

	if(connect(g_sn_mqtt, (struct sockaddr *)&addr, sizeof(addr)) < 0) {
		mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP connect fails in function[%s] line[%d]\n", __FUNCTION__, __LINE__);
		return -1;
	}
	static char cClientID[MAX_MQTTID_LEN+1] = {0};
	snprintf(cClientID, MAX_MQTTID_LEN, "BM%s", g_localIP);
	data.clientID.cstring = cClientID;
	data.keepAliveInterval = keepalive;
	data.cleansession = 1;
	len = MQTTSerialize_connect(buf, buflen, &data);

	if(send(g_sn_mqtt, buf, len, 0) != len) {
		mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP send false!\n");
		return -1;
	}
	/* wait for connack */
	if (MQTTPacket_read(buf, buflen, self_getdata) == CONNACK) {
		unsigned char sessionPresent, connack_rc;
		if (MQTTDeserialize_connack(&sessionPresent, &connack_rc, buf, buflen) != 1 || connack_rc != 0){
			return 1;
		}
		return 0;
	}
	else
		return 1;
}

static int subTopic(char *topic, int msgid, int qos)
{
	if (topic == NULL){
		mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP function[%s] topic == NULL!\n", __FUNCTION__);
		return 1;
	}

	MQTTString topicString = MQTTString_initializer;
	topicString.cstring = topic;
	uint8_t buf[200];
	int buflen = sizeof(buf);

	int req_qos = qos; 
	int len = MQTTSerialize_subscribe(buf, buflen, 0, msgid, 1, &topicString, &req_qos);

	int rc = send(g_sn_mqtt, buf, len, 0);
	if(rc != len) {
		mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP send false!\n");
		return 1;		
	}
	if(MQTTPacket_read(buf, buflen, self_getdata) == SUBACK) {

		unsigned short submsgid;
		int subcount;
		int granted_qos;
		rc = MQTTDeserialize_suback(&submsgid, 1, &subcount, &granted_qos, buf, buflen);
		if (granted_qos != 0) {
			return 1;
		}
		return 0;
	}
	else
		return 1;
}

static int dealMsg()
{
	fd_set rset;
	fd_set wset;
	struct timeval timeout;
	uint8_t cbuf[MAX_PUSHDATA_LEN]={0};
	int buflen = sizeof(cbuf);
	int lastMsgIn = time(NULL);
	int now = lastMsgIn;
	//char cmdUUID[40] = {0};
	int needW = 0;
	char cHttpBuf[1024] = {};
	static int self_boot_flag = 0;
	log__printf(NULL, MOSQ_LOG_ERR,  "function[%s] line[%d] pushDEAL!!!!!\r\n", __FUNCTION__, __LINE__);	
	while(1) {
        
        	if (g_sn_http < 0) {
            
            		int iret = initHttpAndCon();
            		if (iret != 0) {
                		sleep(1);
				if (g_sn_http >= 0) {
					close(g_sn_http);
				}
				g_sn_http = -1;
                		continue;
			}

			if(self_boot_flag == 0){ //The first time to connect to cloud server since program boot
					
				if(g_sn_Cloud_Port != 80) {
                    			sprintf(cHttpBuf, "POST /sh-web/newsh/api/mqtt/client/clearTopic.do?ip=%s HTTP/1.1\r\nHost: %s:%d\r\nConnection: keep-alive\r\nUser-Agent: Apache-HttpClient/UNAVAILABLE (java 1.4)\r\n\r\n", g_localIP, g_sn_CloudAddr, g_sn_Cloud_Port);
                		} else{
                    			sprintf(cHttpBuf, "POST /sh-web/newsh/api/mqtt/client/clearTopic.do?ip=%s HTTP/1.1\r\nHost: %s\r\nConnection: keep-alive\r\nUser-Agent: Apache-HttpClient/UNAVAILABLE (java 1.4)\r\n\r\n", g_localIP, g_sn_CloudAddr);
                		}

				log__printf(NULL, MOSQ_LOG_ERR,  "function[%s] line[%d] mosquitto CHF: %s!!!!!\r\n", __FUNCTION__, __LINE__, cHttpBuf);
				int transLen = strlen(cHttpBuf);
                		int sendLen = 0;
                		int sendedL = 0;
                		do{
                    			sendLen = send(g_sn_http, &(cHttpBuf[sendedL]), transLen-sendedL, 0);
                    			if(sendLen < 0) {
                        			if(errno != EAGAIN && errno != EWOULDBLOCK && errno != EWOULDBLOCK) {
                            				mosquitto_log_printf(MOSQ_LOG_NOTICE,  "function[%s] line[%d] error[%d] reason[%s]!\r\n", __FUNCTION__, __LINE__, errno, strerror(errno));
                            				break;
                        			} else {
                            				mosquitto_log_printf(MOSQ_LOG_NOTICE,  "function[%s] line[%d] error[%d] reason[%s]!\r\n", __FUNCTION__, __LINE__, errno, strerror(errno));
                            				continue;
                        			}
                    			}
                    			sendedL += sendLen;
                		} while(sendedL < transLen);
				log__printf(NULL, MOSQ_LOG_ERR,  "function[%s] line[%d] mosquitto BOOT!!!!!\r\n", __FUNCTION__, __LINE__);
                		cHttpBuf[0] = '\0';
                		self_boot_flag = 1;
			}
		}

		FD_ZERO(&rset);
		FD_SET(g_sn_mqtt, &rset);
        	FD_SET(g_sn_http, &rset);
        	timeout.tv_sec = 1;
		timeout.tv_usec = 0;
        	FD_ZERO(&wset);
        	if (needW > 0)
            		FD_SET(g_sn_http, &wset);

        	int maxFd = g_sn_mqtt > g_sn_http ? g_sn_mqtt : g_sn_http;
        	int ret = select(maxFd+1, &rset, &wset, NULL, &timeout);

		if(ret < 0) {
			mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP select return wrong!\n");
			return 1;
		} else if(ret == 0) {
			now = time(NULL);
			if(now - lastMsgIn >= MQTT_HEART_BEAT_INTERVAL) {
				int len = MQTTSerialize_pingreq(cbuf, buflen);
				if(send(g_sn_mqtt, cbuf, len, 0) != len){
					mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP The send fails!\r\n");
					return 1;
				}
			}
		} else if (FD_ISSET(g_sn_http, &rset)) {
			char buf[4096] = "";
			int rc = recv(g_sn_http, buf, sizeof(buf), 0);
			if (rc == 0) { //recv fin, so ,reconnect!
                		mosquitto_log_printf(MOSQ_LOG_NOTICE,  "http channel recv fin!\r\n");
				close(g_sn_http);
        			g_sn_http = -1;
                		continue;
            		}
        	} else if (FD_ISSET(g_sn_http, &wset)) {
			int transLen = strlen(cHttpBuf);
			int sendLen = 0;
			int sendedL = 0;
			do{
				sendLen = send(g_sn_http, &(cHttpBuf[sendedL]), transLen-sendedL, 0);
                		if(sendLen < 0) {
                    			if(errno != EAGAIN && errno != EWOULDBLOCK && errno != EWOULDBLOCK) {
                        			mosquitto_log_printf(MOSQ_LOG_NOTICE,  "function[%s] line[%d] error[%d] reason[%s]!\r\n", __FUNCTION__, __LINE__, errno, strerror(errno));
                        			break;
                    			} else {
                        			mosquitto_log_printf(MOSQ_LOG_NOTICE,  "function[%s] line[%d] error[%d] reason[%s]!\r\n", __FUNCTION__, __LINE__, errno, strerror(errno));
                        			continue;
                    			}
                		}
               			sendedL += sendLen;
			} while(sendedL < transLen);
			cHttpBuf[0] = '\0';
			needW = 0;
        	}else if (FD_ISSET(g_sn_mqtt, &rset)) {
			lastMsgIn = time(NULL);
			memset(cbuf, 0, sizeof(cbuf));
			buflen = sizeof(cbuf);
			int rc = MQTTPacket_read(cbuf, buflen, self_getdata);
			mosquitto_log_printf(MOSQ_LOG_NOTICE,  "sp read [%d] packet!\n", rc);
			if(rc == -1) {
				mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP The MQTTPacket_read fails!\r\n");
				return 1;
			}else{
				switch (rc) {
                    			case PUBLISH: {
                        			unsigned char dup;
                        			int qos;
                        			unsigned char retained;
                        			unsigned short msgid;
                        			int payloadlen_in;
                        			uint8_t* payload_in;
                        			MQTTString receivedTopic;

                        			rc = MQTTDeserialize_publish(&dup, &qos, &retained, &msgid, &receivedTopic, &payload_in, &payloadlen_in, cbuf, buflen);
                        			mosquitto_log_printf(MOSQ_LOG_NOTICE,  "self receive[%d][%s]\r\n", payloadlen_in, payload_in);
                        
                        			char orgMesg[1024] = {0};   
                        			int len = MQTTSerialize_puback(cbuf, buflen, msgid);
                        			if(send(g_sn_mqtt, cbuf, len, 0) != len) {
                            				mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP The send fails!\r\n");
                            				return 1;
                        			}
                        			do {
                            				//const char *pDst = NULL;
                            				memset(orgMesg, 0, sizeof(orgMesg));
                            				memcpy(orgMesg, payload_in, payloadlen_in);
                            				mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP the orgMesg is [%s]\r\n", orgMesg);
                            
                            				needW = 1;
                            				//sprintf(cHttpBuf, );
                            				if(g_sn_Cloud_Port != 80) {
                               					sprintf(cHttpBuf, "POST /sh-web/newsh/api/mqtt/client/%s HTTP/1.1\r\nHost: %s:%d\r\nConnection: keep-alive\r\nUser-Agent: Apache-HttpClient/UNAVAILABLE (java 1.4)\r\n\r\n", orgMesg, g_sn_CloudAddr, g_sn_Cloud_Port);
                            				} else{
                                				sprintf(cHttpBuf, "POST /sh-web/newsh/api/mqtt/client/%s HTTP/1.1\r\nHost: %s\r\nConnection: keep-alive\r\nUser-Agent: Apache-HttpClient/UNAVAILABLE (java 1.4)\r\n\r\n", orgMesg, g_sn_CloudAddr);
                            				}
                        			} while (0);
                        			break;
                    			}
					case DISCONNECT:{
                        			break;
                    			}
                    			default:{
                        			break;
                    			}
				}
			}
		} else {
			mosquitto_log_printf(MOSQ_LOG_NOTICE, "SP Must not be here!!!\n");
			break;
		}
	}
	return 0;
}


static void* subself_pushloop(void *arg)
{
	int status = 0;	
	int step = 0;
        prctl(PR_SET_NAME, "mosquitto_push_thread", NULL, NULL, NULL); 
    	while (1) {
        	if(step == 0){
            		if(initMqtt() != 0) {
                		step = 0;
                		status = 1;
            		} else {
                		step = 1;
            		}
        	}

        	if(step == 1) {
            		mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP g_sn_pushAddr[%s], g_sn_pushPort[%d]\r\n", g_sn_mqttS_ip, 1883);
            		if(connectWithMqttS(g_sn_mqttS_ip, 1883, 90) != 0) {
                		step = 0;
                		status = 1;
            		} else {
                		step = 2;
            		}
        	}

        	if(step == 2) {
            		static char cTopic[40] = {0};
            		sprintf(cTopic, "$SYS/Connect/Stat");
            		mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP topic[%s]\r\n", cTopic);

            		int packetId = 2;
            		int req_qos = 0; 

            		if(subTopic(cTopic, packetId, req_qos) != 0) {
                		step = 0;
                		status = 1;
            		} else {
                		step = 3;
                		mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP push ok!\r\n");
            		}
        	}
        	
		if(step == 3) {
            		if(dealMsg()) {
                		step = 0;
                		status = 1;
            		} else {
                		mosquitto_log_printf(MOSQ_LOG_NOTICE,  "SP Must not be here!!!\n");
            		}
        	}
		if(status == 1) {
            		close(g_sn_mqtt);
            		g_sn_mqtt = -1;
            		sleep(10);
        	} 
    	}
	return NULL;
}

void startpushloop(void* arg)
{
#if 0 //zhan jianhui
	pthread_t pid_pushloop = -1;
#ifdef pthread_create
#undef pthread_create
	int iret = pthread_create(&pid_pushloop, NULL, subself_pushloop, NULL);
#define pthread_create(A, B, C, D)
#endif
	if(0 == iret) {
		mosquitto_log_printf(MOSQ_LOG_NOTICE, "the function[%s] line[%d] 2success\r\n", __FUNCTION__, __LINE__);
	} else {
		mosquitto_log_printf(MOSQ_LOG_NOTICE, "the function[%s] line[%d] failed\r\n", __FUNCTION__, __LINE__);
	}
#endif
}

