/*
Copyright (c) 2009-2016 Roger Light <roger@atchoo.org>

All rights reserved. This program and the accompanying materials
are made available under the terms of the Eclipse Public License v1.0
and Eclipse Distribution License v1.0 which accompany this distribution.

The Eclipse Public License is available at
   http://www.eclipse.org/legal/epl-v10.html
and the Eclipse Distribution License is available at
  http://www.eclipse.org/org/documents/edl-v10.php.

Contributors:
   Roger Light - initial implementation and documentation.
*/

#include <stdio.h>
#include <string.h>

#include "config.h"

#include "mosquitto_broker_internal.h"
#include "memory_mosq.h"
#include "mqtt3_protocol.h"
#include "packet_mosq.h"
#include "send_mosq.h"
/*
#include "sys_tree.h"
#include "time_mosq.h"
#include "tls_mosq.h"
#include "util_mosq.h"
*/

int handle__unsubscribe(struct mosquitto_db *db, struct mosquitto *context)
{
	uint16_t mid;
	char *sub;

	if(!context) return MOSQ_ERR_INVAL;
#ifdef WITH_CLUSTER //zhan jianhui
    if(!context->is_peer)
	  log__printf(NULL, MOSQ_LOG_DEBUG, "Received UNSUBSCRIBE from %s", context->id);
    else
	  log__printf(NULL, MOSQ_LOG_DEBUG, "[CLUSTER] Received UNSUBSCRIBE from peer: %s", context->id);
#endif
	if(context->protocol == mosq_p_mqtt311){
		if((context->in_packet.command&0x0F) != 0x02){
			return MOSQ_ERR_PROTOCOL;
		}
	}
	if(packet__read_uint16(&context->in_packet, &mid)) return 1;

	while(context->in_packet.pos < context->in_packet.remaining_length){
		sub = NULL;
		if(packet__read_string(&context->in_packet, &sub)){
			return 1;
		}

		if(sub){
			if(STREMPTY(sub)){
				log__printf(NULL, MOSQ_LOG_INFO,
						"Empty unsubscription string from %s, disconnecting.",
						context->id);
				mosquitto__free(sub);
				return 1;
			}
			if(mosquitto_sub_topic_check(sub)){
				log__printf(NULL, MOSQ_LOG_INFO,
						"Invalid unsubscription string from %s, disconnecting.",
						context->id);
				mosquitto__free(sub);
				return 1;
			}
			if(mosquitto_validate_utf8(sub, strlen(sub))){
				log__printf(NULL, MOSQ_LOG_INFO,
						"Malformed UTF-8 in unsubscription string from %s, disconnecting.",
						context->id);
				mosquitto__free(sub);
				return 1;
			}

			log__printf(NULL, MOSQ_LOG_DEBUG, "\t%s", sub);
#ifdef WITH_CLUSTER
            if(!context->is_peer) /*this is important, to avoid infinite unsub.*/
            {
			  int i;
			  struct mosquitto *node;
			  struct topic_table *topic;
			  for(i=0; i<db->node_count; i++)
			  {
			    node = db->nodes[i];
			    if(node && node->is_node && !node->is_peer && node->state == mosq_cs_connected && node->sock != INVALID_SOCKET)
			    {
				  send__unsubscribe(node, NULL, sub);
			    }
			  }
			  HASH_FIND(hh, db->topics, sub, strlen(sub), topic);
			  if(topic)
			  { /* delete this topic from topic table, pay attention to illegal UNSUBSCRIBE. */
			    topic->ref_cnt--;
				if(topic->ref_cnt == 0)
				{
			      HASH_DELETE(hh, db->topics, topic);
				  if(topic->topic_payload) mosquitto__free(topic->topic_payload);
				  mosquitto__free(topic);
				}
			  }
            }
#endif
			sub__remove(db, context, sub, db->subs);
			log__printf(NULL, MOSQ_LOG_UNSUBSCRIBE, "%s %s", context->id, sub);
#if 0
            char buf[1024] = {};
			sprintf(buf, "unsub?clientId=%s&topic=%s&ip=%s", context->id, sub, g_localIP);
			//printf("the lost sub[%s]\r\n", buf);
			db__messages_easy_queue(db, NULL, "$SYS/Connect/Stat", 0, strlen(buf), buf, 1);
#endif
			mosquitto__free(sub);
		}
	}
#ifdef WITH_PERSISTENCE
	db->persistence_changes++;
#endif

	return send__command_with_mid(context, UNSUBACK, mid, false);
}

