package org.eclipse.jubula.rc.swing.tester;

import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.swing.tester.util.TesterUtil;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.jubula.tools.utils.TimeUtil;

public class ApplicationDragAndDrop extends SwingApplicationTester
{	
	public void rcDragApp(int mouseButton, String modifier, int xPos,
			String xUnits, int yPos, String yUnits){
		System.out.println("blabla");
		if (xPos < 0 || yPos < 0) {
            throw new StepExecutionException(
                    "The x-position and y-position must be positive",
                    EventFactory.createActionError());
        }
		final DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        dndHelper.setMouseButton(mouseButton);
        dndHelper.setModifier(modifier);
        final IRobot robot = getRobot();
        rcClickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
        TesterUtil.pressOrReleaseModifiers(modifier, true);
        robot.mousePress(null, null, mouseButton);
	}

	public void rcDropApp(int xPos, String xUnits, int yPos, String yUnits,
	        int delayBeforeDrop){       
		if (xPos < 0 || yPos < 0) {
            throw new StepExecutionException(
                    "The x-position and y-position must be positive",
                    EventFactory.createActionError());
        }
		final DragAndDropHelper dndHelper = DragAndDropHelper.getInstance();
        final String modifier = dndHelper.getModifier();
        final int mouseButton = dndHelper.getMouseButton();
        try {
            rcClickDirect(0, mouseButton, xPos, xUnits, yPos, yUnits);
            TimeUtil.delay(delayBeforeDrop);
        } finally {
            getRobot().mouseRelease(null, null, mouseButton);
            TesterUtil.pressOrReleaseModifiers(modifier, false);
        }
	}

}