package org.eclipse.jubula.rc.common.adapter;

import java.awt.Frame;

import org.eclipse.jubula.rc.common.adaptable.IAdapterFactory;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.IComponent;
import org.eclipse.jubula.rc.swing.tester.adapter.JComponentAdapter;



public class SwingExtensionApplicationAdapterFactory implements IAdapterFactory {

	public Class[] getSupportedClasses() {
		return new Class[] { Frame.class };
	}

	public Object getAdapter(Class targetedClass, Object objectToAdapt) {
		if (targetedClass.isAssignableFrom(IComponent.class)) {
			if (objectToAdapt instanceof Frame) {
			return new JComponentAdapter(objectToAdapt);
			}
		}
		return null;
	}
}
