package com.acme;

import org.eclipse.jetty.security.AbstractLoginService;

public class FooLoginService extends AbstractLoginService {
	
	public interface Delegate
	{
		String[] loadRoleInfo(UserPrincipal user);
		UserPrincipal loadUserInfo(String username);
	}
	
	protected Delegate _delegate;


	@Override
	protected String[] loadRoleInfo(UserPrincipal user) {
		System.err.println("LOADING ROLE INFO");
		return _delegate.loadRoleInfo(user);
	}

	@Override
	protected UserPrincipal loadUserInfo(String username) {
		System.err.println("LOAD USER INFO");
		return _delegate.loadUserInfo(username);
	}

	
	public void setDelegate(Delegate d)
	{
		_delegate = d;
	}

	public Delegate getDelegate()
	{
		return _delegate;
	}
}
