<%@page pageEncoding="UTF-8"%>
<%
final String elid = request.getParameter("elid");
request.setAttribute("title", "Viewing " + elid);
%>
<%@include file="include/header.jsp" %>

<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.ws.*" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="javax.xml.namespace.*" %>
<%@ page import="javax.xml.ws.BindingProvider" %>
<%@ page import="java.net.*" %>
<%@ page import="java.lang.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.osm.services.webservice.OSMPrincipal" %>
<%@ page import="com.osm.biz.message.MessageCatalogUtil" %>

<%@taglib prefix="osm" uri="/WEB-INF/tlds/Manager.tld" %>

<%
final IQueryService service = new QueryService();

final OSMPrincipal user = (OSMPrincipal)request.getUserPrincipal();
if(user==null) {
    throw new IllegalStateException("No user is logged on.");
}

final GetElementsRequest getElementsRequest = new GetElementsRequest();
getElementsRequest.elids = new ArrayList<String>();
getElementsRequest.elids.add(elid);

final List<WSElement> elements = service.getElements(getElementsRequest);

WSElement element = null;
if(!elements.isEmpty()) {
    element = elements.get(0);
}

if(element==null) {
    throw new IllegalStateException("element " + elid + " doesn't exist or you dont have permission to view it");
}

final String classname = (String)element.attributes.get("CLASS_NAME");
final ClassConfig classConfig = WebConfig.getInstance(getServletContext()).getClass(classname);
if(classConfig==null) {
    throw new IllegalStateException("Class " + classname + " is not configured for viewing.");
}

final FormatUtil formatter = new FormatUtil(getServletContext(), request.getLocale());
final String name = formatter.toDisplayString(element);

// pass through for subpages if they need it.
request.setAttribute("element", element);

String tab = request.getParameter("tab");
if(tab == null || classConfig.getTabConfig(tab)==null) {
    tab = "attributes";
}

final String tabJsp = "tab/" + tab + ".jsp";
%>

<h1><img src="<%=request.getContextPath() + element.attributes.get("IconUrl")%>" alt="icon"> <%=name%></h1>


<%
for(final ComponentConfig component : classConfig.getComponents()) {
    final String file = component.getComponentPage();
    %>
    <jsp:include page="<%=file%>" />
    <%
}
%>

<div class="tabs">
<ul>
<%
    
final Collection<String> tabNames = classConfig.getTabs();

for(final String tabName : tabNames) {
    if(tabName.equals(tab)) {
        out.print("<li class='current'>");
    } else {
        out.print("<li>");
    }

    out.print("<a href='view.jsp?elid="+elid+"&tab="+tabName+"'>");
    out.print(classConfig.getTabConfig(tabName).getDisplayName(request.getLocale()));
    out.print("</a>");

    out.println("</li>");
}
%>
</ul>
<div class="tabcontents">
<jsp:include page="<%=tabJsp%>" />
</div>
</div>

<div id="help-dialog" title="<osm:catgets catalog="model" msg_num="95" message="Help"/>">
<p>
<osm:catgets catalog="model" msg_num="4349" message="This page shows all the element specific information from the database, like the structure, where used, notes and more.  It only shows 1 level of elements in the structure and where used tab, but you can navigate up and down the structure by simply clicking on the element in the corresponding tab."/>
</p>
</div>

<%@include file="include/footer.jsp" %>
