<%@page import="com.osm.biz.message.MessageCatalogUtil"%>
<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.ws.*" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="javax.xml.namespace.*" %>
<%@ page import="javax.xml.ws.BindingProvider" %>
<%@ page import="java.net.*" %>
<%@ page import="java.lang.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.osm.services.webservice.OSMPrincipal" %>
<%
final boolean enableLightbox = WebConfig.getInstance(getServletContext()).getBooleanOption("EnableLightbox", true);
if(enableLightbox) {
%>
    <script type="text/javascript" src="js/jquery.lightbox-0.5.js"></script>
    <script type="text/javascript">
    $(function() {
        $('a.lightbox').lightBox();
    });
    </script>
<%
}
%>
<%

String tab = request.getParameter("tab");
if(tab == null) {
    tab = "attributes";
}

final String elid = request.getParameter("elid");

if(elid!=null && elid.length()!=0) {

    final IQueryService service = new QueryService();

    final OSMPrincipal user = (OSMPrincipal)request.getUserPrincipal();
    if(user==null) {
        throw new IllegalStateException("No user is logged on.");
    }

    final List<WSElement> children = service.getChildren(elid);

    final int itemCount = children.size();

    final FormatUtil formatter = new FormatUtil(getServletContext(), request.getLocale());

    final Set<String> attNameInOrderSet = new HashSet<String>();
    final List<String> attNameInOrderList = new ArrayList<String>();
    
    final Map<String,String> attNameToDisplayString = new HashMap<String,String>();

    for(final WSElement child : children) {
        final ClassConfig classConfig = WebConfig.getInstance(getServletContext()).getClass((String)child.attributes.get("CLASS_NAME"));
        if(classConfig!=null) {
            for(final String attName : classConfig.getAttributeNames()) {
                final AttributeConfig attConfig = classConfig.getAttribute(attName);
                if(attConfig.isVisible()) {
                    attNameToDisplayString.put(attName, attConfig.getDisplayName(request.getLocale()));
                    if(!attNameInOrderSet.contains(attName)) {
                        attNameInOrderList.add(attName);
                        attNameInOrderSet.add(attName);
                    }
                }
            }
        }
    }

    if(itemCount>0) {
        final boolean showObjName = WebConfig.getInstance(getServletContext()).getBooleanOption("ShowObjName", true);
        final boolean showThumbnails = WebConfig.getInstance(getServletContext()).getBooleanOption("ShowThumbnailsInSearchResults", false);
        final int thumbnailWidth = WebConfig.getInstance(getServletContext()).getIntOption("SearchResultsThumbnailWidth", 25);
        final int thumbnailHeight = WebConfig.getInstance(getServletContext()).getIntOption("SearchResultsThumbnailHeight", 25);

        out.println("<div class='results'>");
        final TableUtils table = new TableUtils(out, "results");
        table.startTable();
        table.startRow();
        if(showThumbnails) {
            table.addHeader("");
        }
        table.addHeader("");
        
        for(final String attName : attNameInOrderList) {
            table.addHeader(attNameToDisplayString.get(attName));
        }
        table.endRow();

        int i=0;
        for(final WSElement element : children) {
            final ClassConfig classConfig = WebConfig.getInstance(getServletContext()).getClass((String)element.attributes.get("CLASS_NAME"));
            if(classConfig!=null) {
                table.startRow((i % 2) == 0);
                final String viewLink = "view.jsp?elid=" + element.attributes.get("ELID") + "&tab=" + tab;
                final String displayName = formatter.toDisplayString(element);

                if(showThumbnails) {
                    final String lolaMessage = MessageCatalogUtil.getInstance().getMessage("model", 4304, "Thumbnail for : {1}", request.getLocale());
                    final String thumbnailTitle = MessageCatalogUtil.getInstance().fixMesg(lolaMessage, displayName);
                    final String thumbnailUrl = (String)element.attributes.get("ThumbnailUrl");
                    if(thumbnailUrl!=null) {
                        out.print("<td class='results'><a href=" + request.getContextPath() + thumbnailUrl +
                            "  class='lightbox' title='"+thumbnailTitle+"'><img src='" + request.getContextPath() + thumbnailUrl +
                            "&Size="+thumbnailWidth+"x"+thumbnailHeight+"' "+
                            "width="+thumbnailWidth+" height="+thumbnailHeight+"></td>");
                    } else {
                        table.addCell("");
                    }
                }
                
                if(showObjName) {
                    table.addCell("<img src='"+request.getContextPath() + element.attributes.get("IconUrl")+"' alt='icon'>" + displayName, "View", viewLink);
                } else {
                    table.addCell("<img src='"+request.getContextPath() + element.attributes.get("IconUrl")+"' alt='icon'>", "View", viewLink);
                }

                for(final String attName : attNameInOrderList) {
                    final Object value = element.attributes.get(attName);
                    if(classConfig!=null) {
                        final AttributeConfig attConfig = classConfig.getAttribute(attName);
                        if(value instanceof String && attConfig!=null) {
                            table.addCell(formatter.toString(classConfig.getAttribute(attName).getValueDisplayValue((String)value, request.getLocale())), "View", viewLink);
                        } else {
                            table.addCell(formatter.toString(value), "View", viewLink);
                        }
                    } else {
                        table.addCell(formatter.toString(value));
                    }
                }
            } else {
                //Don't show row
            }
            table.endRow();
            i++;
        }//end for
        table.endTable();
        out.println("</div>");
    } else {
        out.print("<p>");
        out.print(MessageCatalogUtil.getInstance().getMessage("model", 4337, "No children found.", request.getLocale()));
        out.print("</p>");
    }
}

%>