<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.ws.*" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="javax.xml.namespace.*" %>
<%@ page import="javax.xml.ws.BindingProvider" %>
<%@ page import="java.net.*" %>
<%@ page import="java.lang.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.osm.services.webservice.OSMPrincipal" %>
<%@ page import="com.osm.biz.message.MessageCatalogUtil" %>

<%@taglib prefix="osm" uri="/WEB-INF/tlds/Manager.tld" %>
<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.ws.*" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="javax.xml.namespace.*" %>
<%@ page import="javax.xml.ws.BindingProvider" %>
<%@ page import="java.net.*" %>
<%@ page import="java.lang.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.osm.services.webservice.OSMPrincipal" %>
<%
final String elid = request.getParameter("elid");

if(elid!=null && elid.length()!=0) {

    final IQueryService service = new QueryService();

    final OSMPrincipal user = (OSMPrincipal)request.getUserPrincipal();
    if(user==null) {
        throw new IllegalStateException("No user is logged on.");
    }

    final List<WSFile> files = service.getFiles(elid);

    final int itemCount = files.size();

    final FormatUtil formatter = new FormatUtil(getServletContext(), request.getLocale());

    if(itemCount>0) {
        out.println("<div class='results'>");

        final TableUtils table = new TableUtils(out, "results");
        table.startTable();
        table.startRow();
        table.addHeader("");
        table.addHeader(MessageCatalogUtil.getInstance().getMessage("eprojects",833,"File Name", request.getLocale()));
        table.addHeader(MessageCatalogUtil.getInstance().getMessage("eprojects",1040,"File Size", request.getLocale()));
        table.addHeader(MessageCatalogUtil.getInstance().getMessage("eprojects",1039,"File Type", request.getLocale()));
        table.addHeader(MessageCatalogUtil.getInstance().getMessage("eprojects",834,"Store Date", request.getLocale()));
        table.addHeader(MessageCatalogUtil.getInstance().getMessage("eprojects",1043,"Comment", request.getLocale()));
        table.addHeader(MessageCatalogUtil.getInstance().getMessage("eprojects",1041,"Program Name", request.getLocale()));
        table.addHeader(MessageCatalogUtil.getInstance().getMessage("eprojects",1042,"Program Revision", request.getLocale()));
		table.addHeader(MessageCatalogUtil.getInstance().getMessage("model",4240,"Storage Types", request.getLocale()));
        table.endRow();

        int i=0;
        for(final WSFile file : files) {
            final String downloadLink = request.getContextPath() + "/FileRetriever?FileServerPhysicalName="+ file.physName + "&Name=" + file.filename + "&StorageType=" + file.storageType;
            
            table.startRow((i % 2) == 0);

            final int index = file.filename.lastIndexOf('.');
            if(index!=-1) {
                final String ext = file.filename.substring(index);
                final String iconLink = request.getContextPath() + "/IconRetriever?FileExt="+ext;
                table.addCell("<img src=" + iconLink + ">", MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
            } else {
                table.addCell("");
            }
            table.addCell(formatter.toString(file.filename), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
            table.addCell(formatter.toString(file.fileSize), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
            table.addCell(formatter.toString(file.fileType), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
            table.addCell(formatter.toString(file.storedDate), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
            table.addCell(formatter.toString(file.comment), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
            table.addCell(formatter.toString(file.programName), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
            table.addCell(formatter.toString(file.programRevision), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
			table.addCell(formatter.toString(file.storageType), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
            table.endRow();
            i++;
        }
        table.endTable();
        
        out.println("</div>");
    } else {
        out.print("<p>");
        out.print(MessageCatalogUtil.getInstance().getMessage("model", 4334, "No files found.", request.getLocale()));
        out.print("</p>");
    }
}

%>