<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.ws.*" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="javax.xml.namespace.*" %>
<%@ page import="javax.xml.ws.BindingProvider" %>
<%@ page import="java.net.*" %>
<%@ page import="java.lang.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.osm.services.webservice.OSMPrincipal" %>
<%@ page import="com.osm.biz.message.MessageCatalogUtil" %>

<%@taglib prefix="osm" uri="/WEB-INF/tlds/Manager.tld" %>

<%
String all = request.getParameter("all");
if(all == null) {
    all = "false";
}

final String elid = request.getParameter("elid");

String tab = request.getParameter("tab");
if(tab == null) {
    tab = "attributes";
}

final WSElement element = (WSElement)request.getAttribute("element");

final String name = (String)element.attributes.get("NAME");
final String classname = (String)element.attributes.get("CLASS_NAME");

final String title = "Viewing - " + name;

final FormatUtil formatter = new FormatUtil(getServletContext(), request.getLocale(),true);
%>


<%
out.println("<div class='atts'>");

final TableUtils table = new TableUtils(out, "atts");
table.startTable();
table.startRow();
table.addHeader(MessageCatalogUtil.getInstance().getMessage("model", 3146, "Attribute Name", request.getLocale()));
table.addHeader(MessageCatalogUtil.getInstance().getMessage("model", 1283, "Current Value", request.getLocale()));
table.endRow();

final ClassConfig classConfig = WebConfig.getInstance(getServletContext()).getClass(classname);

Collection<String> attNames = classConfig.getAttributeNames();

if(all.equals("true")) {  
    final HashSet<String> sorted = new HashSet<String>();
    for(final String att : element.attributes.keySet()) {
        // TODO sort order isnt correct when its localised
        sorted.add(att);
    }
    
    attNames = sorted;
}

int i = 0;
for(final String attName : attNames) {
    final Object val = element.attributes.get(attName);

    final AttributeConfig attConfig = classConfig.getAttribute(attName);
    if(attConfig!=null ) {
        if(attConfig.isVisible() || all.equals("true")){
             table.startRow((i % 2) == 0);
             table.addCell(attConfig.getDisplayName(request.getLocale()));
        } else {
            continue;
        }
    } else {
           table.startRow((i % 2) == 0);
           table.addCell(attName);
    }
    if(val!=null) {
        if((val instanceof String) && (attConfig != null)) {
            table.addCell(formatter.toString(attConfig.getValueDisplayValue((String)val, request.getLocale())));
        } else {
            table.addCell(formatter.toString(val));
        }
    } else {
        table.addCell("");
    }
    table.endRow();
    i++;
}

table.endTable();
out.println("</div>");

if(all!=null && all.equals("true")) {
%>
<a href="<%=request.getRequestURI()%>?elid=<%=elid%>&tab=<%=tab%>&all=false"><img src="images/tango_up_arrow_blue.png" alt="<osm:catgets catalog="model" msg_num="4295" message="Less"/>"></a>
<%
} else {
%>
<a href="<%=request.getRequestURI()%>?elid=<%=elid%>&tab=<%=tab%>&all=true"><img src="images/tango_down_arrow_blue.png" alt="<osm:catgets catalog="model" msg_num="251" message="More"/>"></a>
<%
}
%>

