<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.ws.*" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="javax.xml.namespace.*" %>
<%@ page import="javax.xml.ws.BindingProvider" %>
<%@ page import="java.net.*" %>
<%@ page import="java.lang.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.osm.services.webservice.OSMPrincipal" %>
<%@ page import="com.osm.biz.message.MessageCatalogUtil" %>

<%@taglib prefix="osm" uri="/WEB-INF/tlds/Manager.tld" %>
<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.ws.*" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="javax.xml.namespace.*" %>
<%@ page import="javax.xml.ws.BindingProvider" %>
<%@ page import="java.net.*" %>
<%@ page import="java.lang.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.osm.services.webservice.OSMPrincipal" %>
<%
final String elid = request.getParameter("elid");

if(elid!=null && elid.length()!=0) {

    final IQueryService service = new QueryService();

    final OSMPrincipal user = (OSMPrincipal)request.getUserPrincipal();
    if(user==null) {
        throw new IllegalStateException("No user is logged on.");
    }

    final List<WSAttachment> attachments = service.getAttachments(elid);

    final int itemCount = attachments.size();

    final FormatUtil formatter = new FormatUtil(getServletContext(), request.getLocale());

    if(itemCount>0) {
        out.println("<div class='results'>");

        final TableUtils table = new TableUtils(out, "results");
        table.startTable();
        table.startRow();
        table.addHeader("");
        table.addHeader(MessageCatalogUtil.getInstance().getMessage("eprojects",50,"Name", request.getLocale()));
        table.addHeader(MessageCatalogUtil.getInstance().getMessage("eprojects",1039,"File Type", request.getLocale()));
        table.addHeader(MessageCatalogUtil.getInstance().getMessage("eprojects",834,"Store Date", request.getLocale()));
        table.endRow();

        int i=0;
        for(final WSAttachment attachment : attachments) {
            table.startRow((i % 2) == 0);

            if(attachment.element!=null) {
                final ClassConfig classConfig = WebConfig.getInstance(getServletContext()).getClass((String)attachment.element.attributes.get("CLASS_NAME"));
                if(classConfig!=null) {
                    final String viewLink = "view.jsp?elid=" + attachment.element.attributes.get("ELID");
                    final String displayName = formatter.toDisplayString(attachment.element);
                    table.addCell("<img src='" + request.getContextPath() + attachment.element.attributes.get("IconUrl") + "' alt='icon'>" + displayName, "View", viewLink);
                    table.addCell(formatter.toString(attachment.element.classname), "View", viewLink);
                    table.addCell("");
                    table.addCell("");
                } else {
                    //Don't show row
                }
            } else if(attachment.file!=null) {
                final String downloadLink = request.getContextPath() + "/FileRetriever?FileServerPhysicalName="+ attachment.file.physName + "&Name=" + attachment.file.filename;
                final String ext = attachment.file.filename.substring(attachment.file.filename.lastIndexOf('.'));
                final String iconLink = request.getContextPath() + "/IconRetriever?FileExt="+ext;
                table.addCell("<img src=" + iconLink + ">", MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
                table.addCell(formatter.toString(attachment.file.filename), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
                table.addCell(formatter.toString(attachment.file.fileType), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
                table.addCell(formatter.toString(attachment.file.storedDate), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
            } else if(attachment.relatedFile!=null) {
                final String downloadLink = request.getContextPath() + "/FileRetriever?FileServerPhysicalName="+ attachment.relatedFile.physName + "&Name=" + attachment.relatedFile.name;
                final String ext = attachment.relatedFile.name.substring(attachment.relatedFile.name.lastIndexOf('.'));
                final String iconLink = request.getContextPath() + "/IconRetriever?FileExt="+ext;
                table.addCell("<img src=" + iconLink + ">", MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
                table.addCell(formatter.toString(attachment.relatedFile.name), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
                table.addCell(formatter.toString(attachment.relatedFile.fileType), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
                table.addCell(formatter.toString(attachment.relatedFile.createDate), MessageCatalogUtil.getInstance().getMessage("model",4339,"Download", request.getLocale()), downloadLink);
            }
            
            table.endRow();
            i++;
        }//end for
        
        table.endTable();
        
        out.println("</div>");
    } else {
        out.print("<p>");
        out.print(MessageCatalogUtil.getInstance().getMessage("model", 4333, "No attachments found.", request.getLocale()));
        out.print("</p>");
    }
}

%>
