<%@page import="com.osm.services.ServiceControllerConfig"%>
<%@page import="com.osm.services.webservice.JettySlaveConfiguration"%>
<%@page import="com.osm.services.configuration.ManagerServiceConfiguration"%>
<%@page import="java.rmi.ConnectException"%>
<%@page import="java.util.Map"%>
<%@page import="com.osm.services.webservice.IStatus"%>
<%@page import="com.osm.services.webservice.JettyServer"%>
<%@page import="com.osm.services.webservice.JettySlave"%>
<%@page import="org.eclipse.jetty.server.Server"%>
<%@page import="com.osm.biz.message.MessageCatalogUtil"%>
<%@page pageEncoding="UTF-8"%>
<%
request.setAttribute("title", MessageCatalogUtil.getInstance().getMessage("model", 15, "Information", request.getLocale()));
%>
<%@include file="include/header.jsp" %>

<%
final com.osm.services.webservice.OSMPrincipal user = (com.osm.services.webservice.OSMPrincipal)request.getUserPrincipal();
if(!user.getIsAdmin()) {
    throw new IllegalAccessException("only admin users can view this page"); //frozen
}

final java.text.DecimalFormat MEMORY_FORMAT_MB = new java.text.DecimalFormat("#,000,000"); //frozen
final java.text.DecimalFormat DECIMAL_0_00_FORMAT = new java.text.DecimalFormat("#0.00"); //frozen

%>

<%@taglib prefix="osm" uri="/WEB-INF/tlds/Manager.tld" %>

<h1><osm:catgets catalog="model" msg_num="15" message="Information"/></h1>

<!--
    Client / Browser specific info shown here.
-->
<%
if("true".equals(request.getParameter("client"))) {
%>
<h2><osm:catgets catalog="model" msg_num="4291" message="Client Info"/></h2>

<table class="info">
<tr>
<td><osm:catgets catalog="model" msg_num="4292" message="Request User Principal"/></td><td><%=request.getUserPrincipal().getName()%></td>
</tr><tr>
<td><osm:catgets catalog="model" msg_num="4293" message="Request Locale"/></td><td><%=request.getLocale()%></td>
</tr>
</table>

<h3><osm:catgets catalog="model" msg_num="4294" message="Header Info"/></h3>
<table class="info">
<%
{
   final java.util.Enumeration e = request.getHeaderNames();
    while(e.hasMoreElements()) {
        final String name = (String)e.nextElement();
        final String value = request.getHeader((String)name);
        out.print("<tr>");
        out.print("<td>");
        out.print(name);
        out.print("</td>");
        out.print("<td>");
        out.print(value);
        out.print("</td>");
        out.print("</tr>");
    }
}
%>
</table>

<h3><osm:catgets catalog="model" msg_num="4322" message="Session Variables"/></h3>
<table class="info">
<%
{
    final java.util.Enumeration e = session.getAttributeNames();
    while(e.hasMoreElements()) {
        final String name = (String)e.nextElement();
        final Object value = session.getAttribute((String)name);
        out.print("<tr>");
        out.print("<td>");
        out.print(name);
        out.print("</td>");
        out.print("<td>");
        out.print(String.valueOf(value));
        out.print("</td>");
        out.print("</tr>");
    }
}
%>
</table>

<%
} // end client info
%>
<!--
    Server specific info shown here.
-->
<%
final IStatus status = JettyServer.getInstance().getStatus();

final long total = status.getTotalMemory();
final long free = status.getFreeMemory();
final long max = status.getMaxMemory();
final long used = total - free;
final double usedMaxPer = ((double) used / (double) max);
final double usedCurrPer = ((double) used / (double) total);

final String percentUsedMemory = DECIMAL_0_00_FORMAT.format(usedCurrPer * 100); //frozen
final String percentMaxMemory =  DECIMAL_0_00_FORMAT.format(usedMaxPer * 100); //frozen

final int percentUsedMemoryInt = (int)(usedMaxPer * 100);
final int freePercentMemoryInt = 100 - percentUsedMemoryInt;

final long uptimeS = status.getUpTime();
final String uptimeString = String.format("%03d days %02d:%02d:%02d", (uptimeS / (60 * 60 * 24)), (uptimeS / (60 * 60)) % 24, (uptimeS / (60)) % 60, (uptimeS % 60)); //frozen
%>
<h2><osm:catgets catalog="model" msg_num="4286" message="Server Info"/></h2>
<table class="info">
<tr><td><osm:catgets catalog="model" msg_num="4283" message="Jetty Version"/></td><td><%=Server.getVersion()%></td></tr>

<%
int slaveCount = 0;
for(ManagerServiceConfiguration serviceConfig : ServiceControllerConfig.getInstance().getServiceConfigurations()) {
    if(serviceConfig.getJavaClass().equals(JettySlave.class.getName())){
        slaveCount++;
    }
}
%>
<tr><td><osm:catgets catalog="model" msg_num="4284" message="Jetty Slaves Configured"/></td><td><%=slaveCount%></td></tr>

<tr><td><osm:catgets catalog="model" msg_num="4285" message="Server Locale"/></td><td><%=java.util.Locale.getDefault()%></td></tr>

<tr><td><osm:catgets catalog="model" msg_num="4299" message="Uptime"/></td><td><%=uptimeString%></td></tr>

<tr><td><osm:catgets catalog="model" msg_num="1777" message="Memory - Java Total"/></td><td><%=MEMORY_FORMAT_MB.format(total)%> bytes</td></tr>

<tr><td><osm:catgets catalog="model" msg_num="1778" message="Memory - Java Free"/></td><td><%=MEMORY_FORMAT_MB.format(free)%> bytes</td></tr>

<tr><td><osm:catgets catalog="model" msg_num="1779" message="Memory - Java Used Heap"/></td><td><%=MEMORY_FORMAT_MB.format(used)%> bytes</td></tr>

<!-- Add colors if % > 90 -->
<tr><td><osm:catgets catalog="model" msg_num="1780" message="Memory - Java Used Heap%"/></td><td><%=percentUsedMemory%> %</td></tr>

<tr><td><osm:catgets catalog="model" msg_num="1781" message="Memory - Java Max"/></td><td><%=MEMORY_FORMAT_MB.format(max)%> bytes</td></tr>

<tr><td><osm:catgets catalog="model" msg_num="1782" message="Memory - Java Max Used%"/></td><td><%=percentMaxMemory%> %</td></tr>
</table>

<h3><osm:catgets catalog="model" msg_num="4321" message="Memory Usage"/></h3>
<table width="90%" class="bar">
    <tr>
        <td height="25" width="<%=percentUsedMemoryInt%>%" class="barused"></td>
        <td width="<%=freePercentMemoryInt%>%" class="barfree"></td>
    </tr>
</table>

<h3><osm:catgets catalog="model" msg_num="4320" message="Disk Usage"/></h3>
<%
for(final java.io.File root : java.io.File.listRoots()) {
    long diskTotal = root.getTotalSpace();
    long diskFree= root.getFreeSpace();
    if(diskTotal!=0) {
        final long diskUsed = diskTotal - diskFree;
        final double diskUsedPer = ((double) diskUsed / (double) diskTotal);
        final int percentDiskUsedInt = (int)(diskUsedPer * 100);
        final int freeDiskPercentMemoryInt = 100 - percentDiskUsedInt;
%>
<h4><%=root.getAbsolutePath()%></h4>
<table width="90%" class="bar">
    <tr>
        <td height="25" width="<%=percentDiskUsedInt%>%" class="barused"></td>
        <td width="<%=freeDiskPercentMemoryInt%>%" class="barfree"></td>
    </tr>
</table>
<%
    }
}
%>

<%
if("true".equals(request.getParameter("env"))) {
%>

<h3><osm:catgets catalog="model" msg_num="4287" message="Properties"/></h3>
<table class="info">
    <tr><th><osm:catgets catalog="model" msg_num="4288" message="Key"/></th><th><osm:catgets catalog="model" msg_num="4289" message="Value"/></th></tr>

	<%
{
   final java.util.Map<Object,Object> propMap = java.lang.System.getProperties();
   
   for (final Object key : propMap.keySet()) {
		System.out.println("Key : " + key.toString() + " Value : " + propMap.get(key));
		out.print("<tr>");
        out.print("<td>");
        out.print(key.toString());
        out.print("</td>");
        out.print("<td>");
        out.print(propMap.get(key));
        out.print("</td>");
        out.print("</tr>");
		}
}
%>
	
</table>

<h3><osm:catgets catalog="model" msg_num="4290" message="Environment"/></h3>
<table class="info">
    <tr><th><osm:catgets catalog="model" msg_num="4288" message="Key"/></th><th><osm:catgets catalog="model" msg_num="4289" message="Value"/></th></tr>
<%
{
     final java.util.Map<String,String> envMap = java.lang.System.getenv();
    	   
    	    for(final Object key : envMap.keySet()) {
    	        out.print("<tr>");
    	        out.print("<td>");
    	        out.print(key.toString());
    	        out.print("</td>");
    	        out.print("<td>");
    	        out.print(envMap.get(key));
    	        out.print("</td>");
    	        out.print("</tr>");
           
           
        }
}
%>
	
	
</table>
<%

} // env if env = true
%>

<h1><osm:catgets catalog="model" msg_num="4323" message="Slaves Info"/></h1>
<%
final Map<Integer,IStatus> slaveStatuses = JettyServer.getInstance().getSlaveStatus();
for(final Object slaveStatus : slaveStatuses.keySet()) {
    try {
        final long slaveUptime = slaveStatuses.get(slaveStatus).getUpTime();
        final String slaveUptimeString = String.format("%03d days %02d:%02d:%02d", (slaveUptime / (60 * 60 * 24)), (slaveUptime / (60 * 60)) % 24, (slaveUptime / (60)) % 60, (slaveUptime % 60)); //frozen

        final long slaveTotal = status.getTotalMemory();
        final long slaveFree = status.getFreeMemory();
        final long slaveMax = status.getMaxMemory();
        final long slaveUsed = slaveTotal - slaveFree;
        final double slaveUsedMaxPer = ((double) slaveUsed / (double) slaveMax);
        final double slaveUsedCurrPer = ((double) used / (double) total);

        final String slavePercentUsedMemory = DECIMAL_0_00_FORMAT.format(slaveUsedCurrPer * 100);
        final String slavePercentMaxMemory =  DECIMAL_0_00_FORMAT.format(slaveUsedMaxPer * 100);

        final int slavePercentUsedMemoryInt = (int)(slaveUsedMaxPer * 100);
        final int slaveFreePercentMemoryInt = 100 - percentUsedMemoryInt;
        %>
        <h2>Slave</h2>
        <table class="info">
            <tr><td>ServiceId</td><td><%=slaveStatus.toString()%></td></tr>
            <tr><td><osm:catgets catalog="model" msg_num="4299" message="Uptime"/></td><td><%=slaveUptimeString%></td></tr>
            <tr><td><osm:catgets catalog="model" msg_num="1777" message="Memory - Java Total"/></td><td><%=MEMORY_FORMAT_MB.format(slaveTotal)%> bytes</td></tr>
            <tr><td><osm:catgets catalog="model" msg_num="1778" message="Memory - Java Free"/></td><td><%=MEMORY_FORMAT_MB.format(slaveFree)%> bytes</td></tr>
            <tr><td><osm:catgets catalog="model" msg_num="1779" message="Memory - Java Used Heap"/></td><td><%=MEMORY_FORMAT_MB.format(slaveUsed)%> bytes</td></tr>
            <!-- Add colors if % > 90 -->
            <tr><td><osm:catgets catalog="model" msg_num="1780" message="Memory - Java Used Heap%"/></td><td><%=slavePercentUsedMemory%> %</td></tr>
            <tr><td><osm:catgets catalog="model" msg_num="1781" message="Memory - Java Max"/></td><td><%=MEMORY_FORMAT_MB.format(slaveMax)%> bytes</td></tr>
            <tr><td><osm:catgets catalog="model" msg_num="1782" message="Memory - Java Max Used%"/></td><td><%=slavePercentMaxMemory%> %</td></tr>
        </table>
        <h3><osm:catgets catalog="model" msg_num="4319" message="Memory"/></h3>
        <table width="90%" class="bar">
            <tr>
                <td height="25" width="<%=slavePercentUsedMemoryInt%>%" class="barused"></td>
                <td width="<%=slaveFreePercentMemoryInt%>%" class="barfree"></td>
            </tr>
        </table>
    <%
    } catch (ConnectException e) {
        // Ignore if slave is died and not restarted yet
    }
}
%>

<div id="help-dialog" title="<osm:catgets catalog="model" msg_num="95" message="Help"/>">
<p>
<osm:catgets catalog="model" msg_num="4344" message="This page shows the Jetty Server status and the configured Jetty Slaves statuses."/>
</div>

<%@include file="include/footer.jsp" %>
