<%@taglib prefix="osm" uri="/WEB-INF/tlds/Manager.tld" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.biz.message.MessageCatalogUtil" %>

<%
final boolean enableLightbox = WebConfig.getInstance(getServletContext()).getBooleanOption("EnableLightbox", true);
if(enableLightbox) {
%>
    <script type="text/javascript" src="js/jquery.lightbox-0.5.js"></script>
    <script type="text/javascript">
        $(function() {
            $('.thumbnail a').lightBox(); // Select all links that contains lightbox in the attribute rel
        });
    </script>
<%
}
%>

<%
final WSElement element = (WSElement)request.getAttribute("element");
final String thumbnailUrl = (String)element.attributes.get("ThumbnailUrl");
final String classname = (String)element.attributes.get("CLASS_NAME");

final ClassConfig classConfig = WebConfig.getInstance(getServletContext()).getClass(classname);
if(classConfig==null) {
    throw new IllegalStateException("Class " + classname + " is not configured for viewing.");
}

final FormatUtil formatter = new FormatUtil(getServletContext(), request.getLocale());
final String name = formatter.toDisplayString(element);

if(thumbnailUrl!=null) {
    final String lolaMessage = MessageCatalogUtil.getInstance().getMessage("model", 4304, "Thumbnail for : {1}", request.getLocale());
    final String thumbnailTitle = MessageCatalogUtil.getInstance().fixMesg(lolaMessage, name);
%>
<div class="thumbnail">
<a href="<%=request.getContextPath() + thumbnailUrl%>" title="<%=thumbnailTitle%>" rel="lightbox">
<img src="<%=request.getContextPath() + thumbnailUrl%>" title="<%=thumbnailTitle%>" alt="<%=thumbnailTitle%>">
</a>
<p><%=thumbnailTitle%></p>
</div>
<%
}
%>