<%@page import="com.osm.biz.message.MessageCatalogUtil"%>
<%@taglib prefix="osm" uri="/WEB-INF/tlds/Manager.tld" %>

<%@ page import="java.util.*" %>
<%@ page import="com.osm.ws.*" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.services.webservice.OSMPrincipal" %>

<%
final String elid = request.getParameter("elid");

final WSElement element = (WSElement)request.getAttribute("element");
final String classname = (String)element.attributes.get("CLASS_NAME");

final ClassConfig classConfig = WebConfig.getInstance(getServletContext()).getClass(classname);
if(classConfig==null) {
    throw new IllegalStateException("Class " + classname + " is not configured for viewing.");
}

final IQueryService service = new QueryService();

final OSMPrincipal user = (OSMPrincipal)request.getUserPrincipal();
if(user==null) {
    throw new IllegalStateException("No user is logged on.");
}

final List<String> states = service.getAvailableStates(elid);

final AttributeConfig attConfig = classConfig.getAttribute("STATE");

final String current = (String)element.attributes.get("STATE");
states.remove(current);

%>
<div class="statechange">
    <h4><osm:catgets catalog="model" msg_num="520" message="Change State"/></h4>
    <form id="statechange" method="get" action="action/changestate.jsp" name="statechange">
    <select name="state">
    <%
    if(states.isEmpty()) {
        out.print("<option value='");
        out.print("");
        out.print("' selected");
        out.print(">");
        out.print(MessageCatalogUtil.getInstance().getMessage("model", 4332, "None Available"));
        out.println("</option>");
    } else {
        for(final String state : states) {
            final String localeState = attConfig.getValueDisplayValue(state, request.getLocale());
            out.print("<option value='");
            out.print(state);
            if(state.equals(current)) {
                out.print("' selected");
            } else {
                out.print("'");
            }
            out.print(">");
            out.print(localeState);
            out.println("</option>");
        }
    }
    %>
    </select>
    <input type="hidden" name="elid" value="<%=elid%>">
    <input type="submit" name="search"
           <%= states.isEmpty() ? "disabled=\"disabled\"" : "" %>
            value="<osm:catgets catalog="model" msg_num="1450" message="Change"/>"
            title="<osm:catgets catalog="model" msg_num="1450" message="Change"/>">
    </form>
</div>
