<%@page import="com.osm.biz.message.MessageCatalogUtil"%>
<%@taglib prefix="osm" uri="/WEB-INF/tlds/Manager.tld" %>

<%@ page import="java.util.*" %>
<%@ page import="com.osm.ws.*" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.services.webservice.OSMPrincipal" %>

<%
final WSElement element = (WSElement)request.getAttribute("element");
final String classname = (String)element.attributes.get("CLASS_NAME");

final ClassConfig classConfig = WebConfig.getInstance(getServletContext()).getClass(classname);
if(classConfig==null) {
    throw new IllegalStateException("Class " + classname + " is not configured for viewing.");
}

final OSMPrincipal user = (OSMPrincipal)request.getUserPrincipal();
if(user==null) {
    throw new IllegalStateException("No user is logged on.");
}

final FormatUtil formatter = new FormatUtil(getServletContext(), request.getLocale());
final String name = formatter.toDisplayString(element);

%>
<%
final String loadRule = WebConfig.getInstance(getServletContext()).getOption("DownloadLoadRule");
String downloadUrl = (String)element.attributes.get("DownloadUrl");
if(downloadUrl != null) {
    downloadUrl += (loadRule!=null ? ("&loadrule=" + loadRule) : "");
    downloadUrl = request.getContextPath() + downloadUrl;
    final String fixed = MessageCatalogUtil.getInstance().fixMesg(
            MessageCatalogUtil.getInstance().getMessage("model", 4440, "Download {1}"), name);
%>
<br><br><br><br>
<div class="download">
    <h4><osm:catgets catalog="model" msg_num="4339" message="Download"/></h4>
    <a href="<%=downloadUrl%>" title="<%=fixed%>"><img src="images/download.png" id="download" alt="<%=fixed%>"></a>
</div>
<%
}
%>