<%@page import="com.osm.biz.message.MessageCatalogUtil"%>
<%@page import="java.text.SimpleDateFormat"%>
<%@page pageEncoding="UTF-8"%>
<%@include file="include/header.jsp" %>
<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="javax.xml.namespace.*" %>
<%@ page import="javax.xml.ws.BindingProvider" %>
<%@ page import="java.net.*" %>
<%@ page import="java.lang.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.osm.services.webservice.OSMPrincipal" %>
<%@ page import="com.osm.ws.*" %>
<%@ page import="java.util.*"%>


<%@taglib prefix="osm" uri="/WEB-INF/tlds/Manager.tld" %>

<%
final IQueryService service = new QueryService();

final OSMPrincipal user = (OSMPrincipal)request.getUserPrincipal();
if(user==null) {
    throw new IllegalStateException("No user is logged on.");
	
}
final String go = request.getParameter("go");
if(go!=null && go.equals("1")) {
    // Remove internal form values.  eg go, add, remove etc
    final String classname = (String)request.getParameter("search.class");

    // Cache the WSClass info
    WSClass classInfo = (WSClass)session.getAttribute("classInfoCache");
    if(classInfo == null || !classInfo.classname.equals(classname)) {
        classInfo = service.getClass(classname);
        session.setAttribute("classInfoCache", classInfo);
    }
	  final URLBuilder builder = new URLBuilder(request);
	 builder.setUri(builder.getUri().replaceAll("advsearch.jsp","advresults.jsp"));
	 
	 final int MAX_ATTS = 10; 
	 for(int i=0;i<MAX_ATTS;i++) {
	 final String attribute = request.getParameter("search.att" + i);
        if(attribute==null) {
            break;
        }
		//final String operator = request.getParameter("search.op" + i);
        final String value = request.getParameter("search.val" + i);
        final Class type = classInfo.attributes.get(attribute).type;
		
		 if(type == java.util.Date.class){
		   final FormatterConfig formatConfig = com.osm.jsp.util.WebConfig.getInstance(getServletContext()).getFormatter(java.util.Date.class.getName());
		   final String formatString = formatConfig.getQueryFormatString(request.getLocale());
            final java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(formatString);

           final Date date = dateFormat.parse(value);
		   final java.text.DateFormat gmt = new java.text.SimpleDateFormat("d MMM yyyy HH:mm:ss G");
            builder.set("search.val" + i, gmt.format(date));
		 }else {
           
             final ClassConfig classConfig = com.osm.jsp.util.WebConfig.getInstance(getServletContext()).getClass(classname);
             final String normal = classConfig.getAttribute(attribute).normaliseValue(value, request.getLocale());
             builder.set("search.val" + i, normal);
        }
	 }
	 builder.remove("go");
     builder.remove("args");

    response.sendRedirect(builder.toString());
    return; 
}
// We arent forwarding to search results, so build the search form.

    request.setAttribute("title", MessageCatalogUtil.getInstance().getMessage("data_mgr", 1041, "advsearch", request.getLocale()));
%>

<h1><osm:catgets catalog="data_mgr" msg_num="1041" message="Advanced Search" /></h1>


<div class="advsearch">
    <form id="advsearch" action="advsearch.jsp" method="GET" name="advsearch">
    <h3><osm:catgets catalog="model" msg_num="1592" message="Class Name"/></h3>
    <select name="search.class" onChange="this.form.go.value=0;this.form.action='advsearch.jsp';this.form.submit();">
	        <%
        String lastClass = (String)session.getAttribute("search.class");

        final String searchClass = (String)request.getParameter("search.class");

        if(searchClass != null) {
            // we are about to query for something we must use that as the session attribute will not be set yet.
            lastClass = searchClass;
        }
        if(lastClass==null) {
            for(final String classname : WebConfig.getInstance(getServletContext()).getClassNames()) {
                final String searchAtt =  WebConfig.getInstance(getServletContext()).getClass(classname).getSimpleSearchAtt();
                if(searchAtt!=null) {
                    lastClass = classname;
                    break;
                }
            }
        }

        // Cache the WSClass info
        WSClass classInfo = (WSClass)session.getAttribute("classInfoCache");
        if(classInfo == null || !classInfo.classname.equals(lastClass)) {
            classInfo = service.getClass(lastClass);
            session.setAttribute("classInfoCache", classInfo);
        }

        final ClassConfig classConfig = WebConfig.getInstance(getServletContext()).getClass(lastClass);

        for(final String classname : WebConfig.getInstance(getServletContext()).getClassNames()) {
            final String searchAtt =  WebConfig.getInstance(getServletContext()).getClass(classname).getSimpleSearchAtt();
            if(searchAtt!=null) {
                out.print("<option value='");
                out.print(classname);
                if(classname.equals(lastClass)) {
                    out.print("' selected");
                } else {
                    out.print("'");
                }
                out.print(">");
                out.print(WebConfig.getInstance(getServletContext()).getClass(classname).getDisplayName(request.getLocale()));
                out.print("</option>");
                out.print("\n");
            }
        }
		%>
	 </select>
    <h3><osm:catgets catalog="model" msg_num="4435" message="Case sensitivity"/></h3>
	<%
    String caseSensitiveString = request.getParameter("case.sensitive");
    boolean caseSensitive = true;
    if(caseSensitiveString == null || caseSensitiveString.isEmpty()) {
        caseSensitive = WebConfig.getInstance(getServletContext()).getBooleanOption("SearchCaseSensitive", true);
    } else {
        caseSensitive = Boolean.parseBoolean(caseSensitiveString);    
    }
    if(caseSensitive) {
        %>
        <input type="radio" name="case.sensitive" value="true" checked><osm:catgets catalog="model" msg_num="4436" message="Case Sensitive"/>
        <input type="radio" name="case.sensitive" value="false"><osm:catgets catalog="model" msg_num="4437" message="Case Insensitive"/>
        <%
    } else {
        %>
        <input type="radio" name="case.sensitive" value="true"><osm:catgets catalog="model" msg_num="4436" message="Case Sensitive"/>
        <input type="radio" name="case.sensitive" value="false" checked><osm:catgets catalog="model" msg_num="4437" message="Case Insensitive"/>
        <%
    }
    %>
	 <h3><osm:catgets catalog="model" msg_num="4301" message="Logical Operator"/></h3>
    <%
    String useAndString = request.getParameter("search.and");
    if(useAndString==null || useAndString.equals("true")) {
        %>
        <input type="radio" name="search.and" value="true" checked><osm:catgets catalog="model" msg_num="4345" message="AND"/>
        <input type="radio" name="search.and" value="false"><osm:catgets catalog="model" msg_num="4346" message="OR"/>
        <%
    } else {
        %>
        <input type="radio" name="search.and" value="true"><osm:catgets catalog="model" msg_num="4345" message="AND"/>
        <input type="radio" name="search.and" value="false" checked><osm:catgets catalog="model" msg_num="4346" message="OR"/>
        <%
    }
    %>
    <br>
	
	<%
    String argsString = request.getParameter("args");
    int args = 0;
    if(argsString != null) {
        args = Integer.parseInt(argsString);
    }
    %>
	
	<input type="hidden" name="args" value="<%=args%>">

    <h3><osm:catgets catalog="model" msg_num="4302" message="Conditions"/></h3>
	
	<%
    final String[] operators = new String[] {
        /*"LIKE", "NOT LIKE",*/ "=", "!=", "<", ">", ">=", "<="
        };

    final int MAX_ATTS = 10; // should match form which creates the search
    for(int i=0;i<MAX_ATTS;i++) {
        String att = request.getParameter("search.att"+i);
        if(att==null) att = "";
        String op = request.getParameter("search.op"+i);
        if(op==null) op = "";
        String val = request.getParameter("search.val"+i);
        if(val==null) val = "";
		
    %>
	
	<select id="searchatt<%=i%>" name="search.att<%=i%>" onChange="this.form.go.value=0;this.form.action='advsearch.jsp';this.form.submit();">
	
	 <%
            String attSelected = (String)request.getParameter("search.att" + i);
            for(final String attname : classConfig.getAttributeNames()) {
                if(attSelected==null) {
                    attSelected = attname;
                }
                out.print("<option value='");
                out.print(attname);
                if(attname.equals(attSelected)) {
                    out.print("' selected");
                } else {
                    out.print("'");
                }
                out.print(">");
                out.print(classConfig.getAttribute(attname).getDisplayName(request.getLocale()));
                out.print("</option>");
                out.print("\n");
            }
            %>
</select>			
	
	<select id="searchop<%=i%>" name="search.op<%=i%>">
            <%
            for(final String operator : operators) {
                out.print("<option value='");
                out.print(operator);
                if(operator.equals(op)) {
                    out.print("' selected");
                } else {
                    out.print("'");
                }
                out.print(">");
                out.print(operator);
                out.print("</option>");
                out.print("\n");
            }
            %>
        </select>

 <%
        final WSAttribute wsAttribute = classInfo.attributes.get(attSelected);
        final boolean isDate = wsAttribute.type == java.util.Date.class;
        if ((classInfo.classname.equals("MASTERDATA") || classInfo.classname.equals("PACKAGE_3D")) && (attSelected.equals("VERSION"))) {
              attSelected = "NAME";    
        }

        if(isDate) {
        %>
<script type="text/javascript">
$(function() {
        $("#searchval<%=i%>").datepicker();
});
</script>
        <%
            try {
                // parse GMT date back to localised date
                final java.text.DateFormat gmt = new java.text.SimpleDateFormat("d MMM yyyy HH:mm:ss G"); //frozen
                final Date d = gmt.parse(val);
                final FormatterConfig formatConfig = com.osm.jsp.util.WebConfig.getInstance(getServletContext()).getFormatter(java.util.Date.class.getName());
                final String formatString = formatConfig.getFormatString(request.getLocale());
                final java.text.SimpleDateFormat dateFormat = new java.text.SimpleDateFormat(formatString);

                val = dateFormat.format(d);
            } catch (java.text.ParseException pe) {
                // ignore
            }
        }
        final Map<String,String> valuesMap = classConfig.getAttribute(attSelected).getAttributeValueMap(request.getLocale());
        String valuesStr = "";
        if(!valuesMap.isEmpty()) {
            // also parse val to localise value too
			 for(final Object key : valuesMap.keySet()) {
                final String key1 = key.toString();
                final String value = valuesMap.get(key);
                valuesStr = valuesStr + "\"" + value + "\", ";
                if(key1.equals(val)) {
                    val = value;
                }
            }
         
        %>
<script type="text/javascript">
$(function() {
    var searchval<%=i%>Tags = [<%=valuesStr%>];
        $("#searchval<%=i%>").autocomplete({
            source: searchval<%=i%>Tags
        });
    });
</script>
        <%
        }
        %>
	
	<input id="searchval<%=i%>" type="text" name="search.val<%=i%>" value="<%=val%>">
	 <%
        if(i==args) {
            if(args<MAX_ATTS-1) {
        %>
            <input type="submit" name="add" value="+" onClick="this.form.go.value=0;this.form.args.value++;this.form.action='advsearch.jsp';this.form.submit()">
        <%
            }
            if(i>0) {
            %>
            <input type="submit" name="remove" value="-" onClick="this.form.go.value=0;this.form.args.value--;this.form.action='advsearch.jsp';this.form.submit()">
            <%
            }
            break;
        }
        %>
	 <br>	
	
	<% } // End of for loop line 184 %>
	
	 <h3><osm:catgets catalog="model" msg_num="4303" message="Order By"/></h3>
    <select name="order.att">
        <%
        final String orderBySelected = (String)request.getParameter("order.att");
        for(final String attname : classConfig.getAttributeNames()) {
            out.print("<option value='");
            out.print(attname);
            if(attname.equals(orderBySelected)) {
                out.print("' selected");
            } else {
                out.print("'");
            }
            out.print(">");
            out.print(classConfig.getAttribute(attname).getDisplayName(request.getLocale()));
            out.print("</option>");
            out.print("\n");
        }
        %>
    </select>
	<select name="order.dir">
        <%
        final String orderDirSelected = (String)request.getParameter("order.dir");
        for(final String attname : new String[] {"ASC", "DSC"}) {
            out.print("<option value='");
            out.print(attname);
            if(attname.equals(orderDirSelected)) {
                out.print("' selected");
            } else {
                out.print("'");
            }
            out.print(">");
            if(attname.equals("ASC")) {
                out.print(MessageCatalogUtil.getInstance().getMessage("workmgr", 1007, "Ascending", request.getLocale()));
            } else {
                out.print(MessageCatalogUtil.getInstance().getMessage("workmgr", 1008, "Descending", request.getLocale()));
            }
            out.print("</option>");
            out.print("\n");
        }
        %>
    </select>
	 <br>
    <input type="hidden" name="go" value="0"/>
    <input type="submit" value="<osm:catgets catalog="model" msg_num="222" message="Search"/>"
           title="<osm:catgets catalog="model" msg_num="222" message="Search"/>"
           onClick="this.form.go.value=1;this.form.action='advsearch.jsp';this.form.submit()">
</form>
</div>

<div id="help-dialog" title="<osm:catgets catalog="model" msg_num="95" message="Help"/>">
<p>
<osm:catgets catalog="model" msg_num="4343" message="This pages allows you to define or refine a complex query.  It allows you to choose which database class you want to search, which attributes and what criteria to look for.  You can configure the query to look for all the criterias (AND) or any of the criteria (OR).  It provides you with the ability to choose what attributes should be used to order the results and in what direction they should be ordered."/>
</div>

<%@include file="include/footer.jsp" %>