<%@page pageEncoding="UTF-8"%>
<%@page import="com.osm.biz.message.MessageCatalogUtil"%>
<%
request.setAttribute("title", MessageCatalogUtil.getInstance().getMessage("model", 530, "Search Results", request.getLocale()));
%>
<%@include file="include/header.jsp" %>

<%@ page import="com.osm.jsp.util.*" %>
<%@ page import="com.osm.ws.*" %>
<%@ page import="com.osm.ws.biz.*" %>
<%@ page import="javax.xml.namespace.*" %>
<%@ page import="javax.xml.ws.BindingProvider" %>
<%@ page import="java.net.*" %>
<%@ page import="java.lang.*" %>
<%@ page import="java.util.*" %>
<%@ page import="com.osm.services.webservice.OSMPrincipal" %>

<%@taglib prefix="osm" uri="/WEB-INF/tlds/Manager.tld" %>

<%
final boolean enableLightbox = WebConfig.getInstance(getServletContext()).getBooleanOption("EnableLightbox", true);
if(enableLightbox) {
%>
    <script type="text/javascript" src="js/jquery.lightbox-0.5.js"></script>
    <script type="text/javascript">
    $(function() {
        $('a.lightbox').lightBox();
    });
    </script>
<%
}
%>

<%

final String searchClass = request.getParameter("search.class");
if (searchClass == null || searchClass.isEmpty()) {
    throw new IllegalStateException("No class defined");
}

final String pageNoString = request.getParameter("pageNo");
int pageNo = -1;
if(pageNoString == null) {
    pageNo = 0;
} else {
    pageNo = Integer.parseInt(pageNoString);
}

final String pageSizeString = request.getParameter("pageSize");
int pageSize = -1;
if(pageSizeString == null) {
    pageSize = WebConfig.getInstance(getServletContext()).getIntOption("DefaultPageSize", 25);
} else {
    pageSize = Integer.parseInt(pageSizeString);
}

String orderByAtt = request.getParameter("order.att");
String orderByDir = request.getParameter("order.dir");
if(orderByAtt == null) {
    orderByAtt = "ELID";
    orderByDir = "ASC";
}

String useAndStr = request.getParameter("search.and");
boolean useAnd = true;
if(useAndStr==null || useAndStr.equals("true")) {
    useAnd = true;
} else {
    useAnd = false;
}

String caseSensitiveString = request.getParameter("case.sensitive");
boolean caseSensitive = true;
if(caseSensitiveString == null || caseSensitiveString.isEmpty()) {
    caseSensitive = WebConfig.getInstance(getServletContext()).getBooleanOption("SearchCaseSensitive", true);
} else {
    caseSensitive = Boolean.parseBoolean(caseSensitiveString);    
}

final IQueryService service = new QueryService();

final OSMPrincipal user = (OSMPrincipal)request.getUserPrincipal();
if(user==null) {
    throw new IllegalStateException("No user is logged on.");
}

final List<OrderBy> orderBys = new ArrayList<OrderBy>();

if(!orderByAtt.equals("ELID")) {
    final OrderBy order = new OrderBy();
    order.attribute = orderByAtt;
    order.ascending = orderByDir.equals("ASC");
    orderBys.add(order);
}
// Must end with ELID to keep paging working.
final OrderBy orderElid = new OrderBy();
orderElid.attribute = "ELID";
orderElid.ascending = orderByDir.equals("ASC");
orderBys.add(orderElid);

final ClassConfig classConfig = WebConfig.getInstance(getServletContext()).getClass(searchClass);

// Cache the WSClass info
WSClass classInfo = (WSClass)session.getAttribute("classInfoCache");
if(classInfo == null || !classInfo.classname.equals(searchClass)) {
    classInfo = service.getClass(searchClass);
    session.setAttribute("classInfoCache", classInfo);
}

QueryExpression expression = null;
final List<QueryExpression> expressions = new ArrayList<QueryExpression>();
if(useAnd) {
    AndQueryCriteria and = new AndQueryCriteria();
    and.expressions = expressions;
    expression = and;
} else {
    OrQueryCriteria or = new OrQueryCriteria();
    or.expressions = expressions;
    expression = or;
}

int arguments = 0;

final java.text.DateFormat gmt = new java.text.SimpleDateFormat("d MMM yyyy HH:mm:ss G"); //frozen

final int MAX_ATTS = 10; // should match form which creates the search
for(int i=0;i<MAX_ATTS;i++) {
    final String attribute = request.getParameter("search.att" + i);
    
    if(attribute==null) break;
    
    final String operator = request.getParameter("search.op" + i);

    // TODO allow option to turn on explict data time search.

    // Special handling for dates.  
    if(classInfo.attributes.get(attribute).type == java.util.Date.class) {
        if(operator.equals("=")) {
            // date = 2008/01/01 should be date =>00:00:00 AND <=23:59:59
            final String value = request.getParameter("search.val" + i);

            final Date date = gmt.parse(value);

            final Date startDate = (Date)date.clone();
            startDate.setHours(0);
            startDate.setMinutes(0);
            startDate.setSeconds(0);
            final QueryCriteria startDay = new QueryCriteria();
            startDay.attribute = attribute;
            startDay.operator = ">=";
            startDay.value = startDate;

            final Date endDate = (Date)date.clone();
            endDate.setHours(23);
            endDate.setMinutes(59);
            endDate.setSeconds(59);
            final QueryCriteria endDay = new QueryCriteria();
            endDay.attribute = attribute;
            endDay.operator = "<=";
            endDay.value = endDate;

            final AndQueryCriteria and = new AndQueryCriteria();
            and.expressions = new ArrayList<QueryExpression>();
            and.expressions.add(startDay);
            and.expressions.add(endDay);
            
            expressions.add(and);
        } else if(operator.equals("!=")) {
            // date != 2008/01/01 should be date <=00:00:00 OR >=23:59:59
            final String value = request.getParameter("search.val" + i);

            final Date date = gmt.parse(value);

            final Date startDate = (Date)date.clone();
            startDate.setHours(0);
            startDate.setMinutes(0);
            startDate.setSeconds(0);
            final QueryCriteria startDay = new QueryCriteria();
            startDay.attribute = attribute;
            startDay.operator = "<";
            startDay.value = startDate;

            final Date endDate = (Date)date.clone();
            endDate.setHours(23);
            endDate.setMinutes(59);
            endDate.setSeconds(59);
            final QueryCriteria endDay = new QueryCriteria();
            endDay.attribute = attribute;
            endDay.operator = ">";
            endDay.value = endDate;

            final OrQueryCriteria or = new OrQueryCriteria();
            or.expressions = new ArrayList<QueryExpression>();
            or.expressions.add(startDay);
            or.expressions.add(endDay);

            expressions.add(or);
        } else if(operator.equals(">")) {
            // date > 2008/01/01 should be date >23:59:59
            final QueryCriteria criteria = new QueryCriteria();
            criteria.attribute = attribute;
            criteria.operator = operator;
            final String value = request.getParameter("search.val" + i);
            final Date date = gmt.parse(value);
            date.setHours(23);
            date.setMinutes(59);
            date.setSeconds(59);
            criteria.value = date;
            expressions.add(criteria);
        } else if(operator.equals(">=")) {
            // date >= 2008/01/01 should be date >=00:00:00
            final QueryCriteria criteria = new QueryCriteria();
            criteria.attribute = attribute;
            criteria.operator = operator;
            final String value = request.getParameter("search.val" + i);
            final Date date = gmt.parse(value);
            date.setHours(0);
            date.setMinutes(0);
            date.setSeconds(0);
            criteria.value = date;
            expressions.add(criteria);
        } else if(operator.equals("<")) {
            // date < 2008/01/01 should be date <00:00:00
            final QueryCriteria criteria = new QueryCriteria();
            criteria.attribute = attribute;
            criteria.operator = operator;
            final String value = request.getParameter("search.val" + i);
            final Date date = gmt.parse(value);
            date.setHours(0);
            date.setMinutes(0);
            date.setSeconds(0);
            criteria.value = date;
            expressions.add(criteria);
        } else if(operator.equals("<=")) {
            // date < 2008/01/01 should be date <=23:59:59
            final QueryCriteria criteria = new QueryCriteria();
            criteria.attribute = attribute;
            criteria.operator = operator;
            final String value = request.getParameter("search.val" + i);
            final Date date = gmt.parse(value);
            date.setHours(23);
            date.setMinutes(59);
            date.setSeconds(59);
            criteria.value = date;
            expressions.add(criteria);
        } else {
            throw new RuntimeException(operator + " is an invalid operator for dates");
        }
    } else if(classInfo.attributes.get(attribute).type == String.class) {
        final StringQueryCriteria criteria = new StringQueryCriteria();
        criteria.attribute = attribute;
        criteria.operator = operator;
        criteria.caseSensitive = caseSensitive;
        final String value = request.getParameter("search.val" + i);
        if(value.isEmpty()) {
            criteria.value = "*";
        } else {
            criteria.value = value;
        }
        expressions.add(criteria);
    } else {
        final QueryCriteria criteria = new QueryCriteria();
        criteria.attribute = attribute;
        criteria.operator = operator;
        final String value = request.getParameter("search.val" + i);
        if(value.isEmpty()) {
            criteria.value = "*";
        } else {
            criteria.value = value;
        }
        expressions.add(criteria);
    }

    arguments ++; // dont use criterias as it could be more
}

if(expressions.isEmpty()) {
    throw new IllegalStateException("No criterias defined");
}

final QueryElementsRequest queryElementsRequest = new QueryElementsRequest();
queryElementsRequest.classname = searchClass;
queryElementsRequest.pageSize = pageSize;
queryElementsRequest.pageNo = pageNo;
queryElementsRequest.definition = expression;
queryElementsRequest.orderBys = orderBys;

final List<WSElement> elements = service.queryElements(queryElementsRequest);

final URLBuilder url = new URLBuilder(request);
// Ensure the builder knows about our defaults if it wasnt set
url.set("order.dir", orderByDir);
url.set("order.att", orderByAtt);

final int itemCount = elements.size();

final FormatUtil formatter = new FormatUtil(getServletContext(), request.getLocale());

final boolean showObjName = WebConfig.getInstance(getServletContext()).getBooleanOption("ShowObjName", true);
final boolean showThumbnails = WebConfig.getInstance(getServletContext()).getBooleanOption("ShowThumbnailsInSearchResults", false);
final int thumbnailWidth = WebConfig.getInstance(getServletContext()).getIntOption("SearchResultsThumbnailWidth", 25);
final int thumbnailHeight = WebConfig.getInstance(getServletContext()).getIntOption("SearchResultsThumbnailHeight", 25);

final URLBuilder refineUrl = url.clone();
refineUrl.setUri(refineUrl.getUri().replaceAll("advresults.jsp", "advsearch.jsp"));
refineUrl.set("args", String.valueOf(arguments-1));
%>
<div class="refine">
<a href="<%=refineUrl.toString()%>" name="modify-query" title="<osm:catgets catalog="model" msg_num="4316" message="Modify Advanced Search"/>""><osm:catgets catalog="model" msg_num="4316" message="Modify Advanced Search"/></a>
</div>

<h1><osm:catgets catalog="model" msg_num="530" message="Search Results" /></h1>

<%
if(itemCount>0) {
%>

<div class="querynav">
<%
if(pageNo!=0) {
    final URLBuilder pageUrl = url.clone();
    pageUrl.set("pageNo", String.valueOf(pageNo-1));
%>
    <a class="left" href="<%=pageUrl.toString()%>"><img src="images/tango_left_arrow_blue.png" id="image-back" alt="<osm:catgets catalog="model" msg_num="2360" message="< Back"/>"></a>
<%
}
if(pageSize == elements.size()) {
    final URLBuilder pageUrl = url.clone();
    pageUrl.set("pageNo", String.valueOf(pageNo+1));
%>
<a class="right" href="<%=pageUrl.toString()%>"><img src="images/tango_right_arrow_blue.png" id="image-next" alt="<osm:catgets catalog="model" msg_num="2361" message="Next >"/>"></a>
<%
}
%>
</div>
<%
    out.println("<div class='results'>");
    final TableUtils table = new TableUtils(out, "results");
    table.startTable();
    table.startRow();
    if(showThumbnails) {
        table.addHeader("");
    }
    table.addHeader("");
    
    for(final String attName : classConfig.getAttributeNames()) {
        // selected down
        final AttributeConfig attConfig = classConfig.getAttribute(attName);
        if(attConfig.isVisible()) {
            if(orderByAtt.equals(attName)) {
                if(orderByDir.equals("ASC")) {
                    final URLBuilder orderUrl = url.clone();
                    orderUrl.set("order.dir", "DSC");
                    table.addHeader("<img src='images/up.png'>"+attConfig.getDisplayName(request.getLocale()), "Sort", orderUrl.toString());
                } else {
                    final URLBuilder orderUrl = url.clone();
                    orderUrl.set("order.dir", "ASC");
                    table.addHeader("<img src='images/down.png'>"+attConfig.getDisplayName(request.getLocale()), "Sort", orderUrl.toString());
                }
            } else {
                final URLBuilder orderUrl = url.clone();
                orderUrl.set("order.dir", "ASC");
                orderUrl.set("order.att", attName);
                table.addHeader(attConfig.getDisplayName(request.getLocale()), "Sort", orderUrl.toString());
            }
        }
    }
    table.endRow();

    int i=0;
    for(final WSElement element : elements) {
        table.startRow((i % 2) == 0);
        final String viewLink = "view.jsp?elid=" + element.attributes.get("ELID");

        final String displayName = formatter.toDisplayString(element);

        if(showThumbnails) {
            final String lolaMessage = MessageCatalogUtil.getInstance().getMessage("model", 4304, "Thumbnail for : {1}", request.getLocale());
            final String thumbnailTitle = MessageCatalogUtil.getInstance().fixMesg(lolaMessage, displayName);
            final String thumbnailUrl = (String)element.attributes.get("ThumbnailUrl");
            if(thumbnailUrl!=null) {
                out.print("<td class='results'><a href=" + request.getContextPath() + thumbnailUrl +
                    "  class='lightbox' title='"+thumbnailTitle+"'><img src='" + request.getContextPath() + thumbnailUrl +
                    "&Size="+thumbnailWidth+"x"+thumbnailHeight+"' "+
                    "width="+thumbnailWidth+" height="+thumbnailHeight+"></td>");
            } else {
                table.addCell("");
            }
        }

        if(showObjName) {
            table.addCell("<img src='" + request.getContextPath() + element.attributes.get("IconUrl")+"' alt='icon'>" + displayName, "View", viewLink);
        } else {
            table.addCell("<img src='" + request.getContextPath() + element.attributes.get("IconUrl")+"' alt='icon'>", "View", viewLink);
        }

        for(final String attName : classConfig.getAttributeNames()) {
            final AttributeConfig attConfig = classConfig.getAttribute(attName);
            if(attConfig.isVisible()) {
                final Object value = element.attributes.get(attName);
                if(value instanceof String) {
                    table.addCell(formatter.toString(classConfig.getAttribute(attName).getValueDisplayValue((String)value, request.getLocale())), "View", viewLink);
                } else {
                    table.addCell(formatter.toString(value), "View", viewLink);
                }
            }
        }

        table.endRow();
        i++;
    }
    table.endTable();
    out.println("</div>");
}
%>

<div class="querynav">
<%
if(pageNo!=0) {
    final URLBuilder pageUrl = url.clone();
    pageUrl.set("pageNo", String.valueOf(pageNo-1));
%>
    <a class="left" href="<%=pageUrl.toString()%>" title="<osm:catgets catalog="model" msg_num="2360" message="< Back"/>"><img src="images/tango_left_arrow_blue.png" alt="<osm:catgets catalog="model" msg_num="2360" message="< Back"/>"></a>
<%
}
%>

<%
if(pageSize == elements.size()) {
    final URLBuilder pageUrl = url.clone();
    pageUrl.set("pageNo", String.valueOf(pageNo+1));
%>
    <a class="right" href="<%=pageUrl.toString()%>" title="<osm:catgets catalog="model" msg_num="2361" message="Next >"/>"><img src="images/tango_right_arrow_blue.png" alt="<osm:catgets catalog="model" msg_num="2361" message="Next >"/>"></a>
<%
}
%>
</div>

<div id="help-dialog" title="<osm:catgets catalog="model" msg_num="95" message="Help"/>">
<p>
<osm:catgets catalog="model" msg_num="4342" message="This page shows the elements from the database which match your search criteria.  The results are limited to 1 page of results and allow you to navigate to the next page (if any exist) by using the next button.  You can then use back button to the previous page.   You can select a column header to order the results by that attribute.  Selecting the same column again will switch the ordering.  Clicking a element in the results will open the view page for that element.  You can also click the 'Modify Advanced Search' link to modify and refine the search criteria."/>
</p>
</div>

<%@include file="include/footer.jsp" %>
