/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.security;

/**
 * @author rduggan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.NoSuchProviderException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.UnrecoverableKeyException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.io.File;
import java.io.IOException;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import java.io.DataInputStream;
import java.io.FileNotFoundException;

public class KeyStoreHelper {
	
	
	public static KeyStore createKeyStore(String pathname, String password)
	   throws KeyStoreException,
	           NoSuchAlgorithmException,
	           CertificateException,
	           IOException,
	           NoSuchProviderException  {
	           	
	    KeyStore ks=KeyStore.getInstance("JKS");
		
		File file=new File(pathname);
		
		/* Do not stomp an existing file */
		if(!file.exists()) {
			ks.load(null, password.toCharArray());
			persistKeyStore(ks, pathname, password);
		}
		else {
			return loadKeyStore(pathname, password);
		}
		return ks;
	}
	
	public static KeyStore loadKeyStore(String pathname, String password)
	   throws KeyStoreException,
	           NoSuchAlgorithmException,
	           CertificateException,
	           IOException,
	           NoSuchProviderException  {
		
		KeyStore ks=null;
		File file=new File(pathname);
		
		/* Do not stomp an existing file */
		if(file.exists()) {
			ks=KeyStore.getInstance("JKS");
			/* Initialize the keystore with no information */
			FileInputStream is=new FileInputStream(file);
			ks.load(is, password.toCharArray());
			is.close();
		}
		return ks;
	}
	
	public static Certificate loadCertificate(String certFilename) 
	   throws CertificateException,
	           FileNotFoundException {
		
		CertificateFactory factory=CertificateFactory.getInstance("X.509");
		
		return factory.generateCertificate(new FileInputStream(certFilename));
	}
	
	public static void addCertificateToKeyStore(KeyStore ks, Certificate cert, String alias)
		      throws KeyStoreException {
		ks.setCertificateEntry(alias, cert);
			
	}
	
	public static void persistKeyStore(KeyStore ks, String pathname, String password) 
		throws KeyStoreException,
		        FileNotFoundException,
		        NoSuchAlgorithmException,
		        CertificateException,
		        IOException {
		FileOutputStream os=new FileOutputStream(pathname);
		ks.store(os, password.toCharArray());
		os.close();
		
		
	}
	
	public static void main(String[] args) {
		try {
			KeyStore ks=KeyStoreHelper.createKeyStore("d:\\build\\ikeyman\\genkey", "richard");
			Certificate cert=KeyStoreHelper.loadCertificate("d:\\build\\ikeyman\\cert.arm");
			KeyStoreHelper.addCertificateToKeyStore(ks, cert, "richardCA");
			KeyStoreHelper.persistKeyStore(ks, "d:\\build\\ikeyman\\genkey", "richard");
			
			
		}
		catch(Exception e) {
			System.out.println("Error creating keystore "+e.getMessage());
		}
	}

}
