/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.control;

import org.eclipse.hyades.internal.execution.local.common.CommandElement;


public interface AgentListener {
	
	
	/**
	 * Invoked when an agent first becomes active
	 */
	void agentActive(Agent agent);
	
	/**
	 * Invoked when an agent becomes inactive.
	 */
	void agentInactive(Agent agent);
	
	/**
	 * Invoked when an error is recieved from the agent.
	 */
	void error(Agent agent, String errorId, String errorMessage);

	/**
	 * Invoked when there is no established handler for the context of a message.
	 */
	void handleCommand(Agent agent, CommandElement command);

}

