/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (6/2/00 1:31:54 PM)
 * @author: Administrator
 */
public class StartMonitoringRemoteAgentCommand extends SimpleAgentInfoCommand {

	protected long _port=0;
	protected long _ip=0;
/**
 * SetMonitorCommandEntry constructor comment.
 */
public StartMonitoringRemoteAgentCommand() {
	super();
	_tag=RA_START_MONITORING_AGENT_REMOTE;
}
/**
 * Insert the method's description here.
 * Creation date: (11/3/00 11:06:34 AM)
 */
public long getIP() {
	return _ip;
}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 12:23:51 PM)
 * @return short
 */
public long getPort() {
	return _port;
}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 12:58:48 PM)
 * @return int
 */
public int getSize() {
	return super.getSize()+2*sizeofLong;
}
/**
 * Insert the method's description here.
 * Creation date: (9/11/00 9:25:14 PM)
 * @return int
 * @param buffer byte[]
 * @param length int[]
 */
public int readFromBuffer(byte[] buffer, int offset) {
	int current=super.readFromBuffer(buffer, offset);

	_ip=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;
	
	_port=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;

	return current;
}
/**
 * Insert the method's description here.
 * Creation date: (11/3/00 11:06:19 AM)
 * @param param java.net.InetAddress
 */
public void setInetAddress(java.net.InetAddress param) {}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 12:23:41 PM)
 * @param port short
 */
public void setPort(short port) {
	_port=port;
}
/**
 * Insert the method's description here.
 * Creation date: (7/21/00 3:41:09 PM)
 * @return int
 * @param buffer byte[]
 * @param offset int
 */
public int writeToBuffer(byte[] buffer, int offset) {
	int current=super.writeToBuffer(buffer, offset);
	current=Message.writeRALongToBuffer(buffer, current, _ip);
	current=Message.writeRALongToBuffer(buffer, current, _port);
	
	return current;
}
}
