/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

import java.net.InetAddress;
import java.net.UnknownHostException;

class RAInetAddress implements Constants {

	protected byte[] _data=null;
	protected int _length=0;
	protected InetAddress _address=null;

public RAInetAddress() {
	super();
}

public int getLength() {
	return _length;
}


public void setLength(int length) {
	_length=length;
}

public void setData(byte[] data) {
	_data=data;
}

public int getSize() {
	return sizeofByte+_length;	
}



public InetAddress getAddress() throws UnknownHostException {
	/* Check our cache */
	if(_address!=null) {
		return _address;
	}
	
	if(_length==0) {
		return null;
	}
	/* Build a string representing the IP address in decimal form */
	String addr=new String();
	addr+=Byte.toString(_data[0]);
	for(int i=1; i<_length; i++) {
		addr=addr+"."+Byte.toString(_data[i]);
	}
	
	/* Lookup all the InetAddress objects for this address */
	InetAddress addrs=InetAddress.getByName(addr);
	
	/* Search for our match: RKD:  This was removed aswe probablydon't need all the addresses.
	for(int j=0; j<addrs.length; j++) {
		if(addrs[j].getHostAddress().equals(addr)) {
			_address=addrs[j];
			return _address;
		}
	}
	return null
	*/
	
	return addrs;
}

}
