/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * Insert the type's description here.
 * Creation date: (2/19/01 2:42:57 PM)
 * @author: Richard K. Duggan
 */
import java.net.Socket;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.net.InetAddress;
import java.io.InputStream;
import java.io.IOException;
import java.io.InterruptedIOException;

public class Console extends Thread implements Constants {

	protected ServerSocket 	_sock;
	protected DataProcessor _processor=null;
	protected long _ip=0;
	protected long _port=0;
	private boolean _started=false;
	private boolean _valid=true;
	private Socket _activeConnection=null;
	
	
/**
 * Console constructor comment.
 */
public Console() {
	super();
	/* Don't block the VM from exiting */
	this.setDaemon(true);
}
/**
 * Console constructor comment.
 * @param name java.lang.String
 */
public Console(String name) {
	super(name);
	/* Don't block the VM from exiting */
	this.setDaemon(true);
}
/**
 * Console constructor comment.
 * @param group java.lang.ThreadGroup
 * @param name java.lang.String
 */
public Console(ThreadGroup group, String name) {
	super(group, name);
	/* Don't block the VM from exiting */
	this.setDaemon(true);
}
/**
 * Insert the method's description here.
 * Creation date: (2/19/01 2:44:15 PM)
 * @return long
 */
public long getIP() throws ConsoleNotStartedException {
	if(_ip==0) {
		throw new ConsoleNotStartedException();
	}
	return _ip;
}
/**
 * Insert the method's description here.
 * Creation date: (2/19/01 2:43:59 PM)
 * @return long
 */
public long getPort() throws ConsoleNotStartedException {
	if(_port==0) {
		throw new ConsoleNotStartedException();
	}
	return _port;
}
/**
 * Insert the method's description here.
 * Creation date: (2/19/01 2:43:25 PM)
 */
public void run() {
	byte[] buffer=new byte[1024];
	short port=0/*DATA_PORT_NUM_CLIENT*/;
	boolean started=false;
	boolean complete;

	/* Start the server */
	while(!started) {
		try {
			started=true;
			_sock=new ServerSocket(port, 1);
		}
		catch(Exception e) {
			port++;
			started=false;
		}
	}

	/* Store the address information of this console */
	_port=_sock.getLocalPort();
	try {
		byte[] bytes = InetAddress.getLocalHost().getAddress();
		_ip=(long)(bytes[3]<<24    & 0xff000000)
				| (long)(bytes[2]<<16 & 0x00ff0000)
				| (long)(bytes[1]<<8  & 0x0000ff00)
				| (long)(bytes[0]     & 0x000000ff);
	}
	catch(UnknownHostException e) {
		/* Shouldn't happen as we are looking up the localhost */
	}

	/* Inform the start method we are up */
	synchronized(this) {
		_started=true;
		this.notify();
	}

	while(_valid) {
		InputStream is=null;
		_activeConnection=null;
		try {
			_activeConnection=_sock.accept();
			is=_activeConnection.getInputStream();
			_activeConnection.setSoTimeout(1000);
			complete=false;
		}
		catch(Exception e) {
			/* The server socket is toast, return */
			return;
		}
		while(!complete) {
			int length=0;
			try {
				length=is.read(buffer);
			}
			catch(InterruptedIOException e) {
				/* Read timeout, don't want to wait too long */
				if(_processor != null) {
					_processor.waitingForData();
				}
			}
			catch(IOException e) {
				try {
					_activeConnection.close();
				}
				catch(IOException e1) {
				}
				complete=true;
			}
				
			/* Is the connection closed? */
			if(length<0) {
				try {
					_activeConnection.close();
				}
				catch(IOException e) {
				}
				complete=true;
			}
			else if(length > 0) {
				if(_processor != null) {
					_processor.incommingData(buffer, length, _activeConnection.getInetAddress());
				}
			}
			
			/* Have we been asked to stop. */
			if(!_valid) {
				try {
				_activeConnection.close();
				}
				catch(IOException e1) {
				}
				complete=true;	
			}
		}
	}
	
	
		
	
	
}
/**
 * Insert the method's description here.
 * Creation date: (2/19/01 2:56:30 PM)
 * @param processor org.eclipse.hyades.internal.execution.local.common.DataProcessor
 */
public void setDataProcessor(DataProcessor processor) {
	_processor=processor;
	
}


public DataProcessor getDataProcessor() {
	return _processor;
}

/**
 * Insert the method's description here.
 * Creation date: (2/19/01 5:39:25 PM)
 */
public void start() {
	/* We need to wait until the server is fully up */
	synchronized(this) {
		_valid=true;
		super.start();
		do {
			try {
				this.wait();
			}
			catch(InterruptedException e) {
			}
		}while(!_started);
	}	
}
/**
 * Insert the method's description here.
 * Creation date: (5/28/01 8:01:54 PM)
 * @param data java.lang.String
 */
public void write(String data) {
	if(_activeConnection!=null) {
		try {
			_activeConnection.getOutputStream().write(data.getBytes());
		}
		catch(Exception e) {
		}
	}
}

/* Closes this console */
public void close() {
	_valid=false;
}

}
