/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.execution.local;

/**
 * Execution state change implementation for LocalExecutionComponents.
 */

import org.eclipse.hyades.execution.core.IExecutionComponent;
import org.eclipse.hyades.execution.core.IExecCompStateChangeEvent;
import org.eclipse.hyades.execution.core.IExecutionComponentState;

public class LocalExecCompStateChangeEvent implements IExecCompStateChangeEvent {
	protected IExecutionComponentState state;
	protected IExecutionComponent targetIEC;
	
	LocalExecCompStateChangeEvent(IExecutionComponent iec, IExecutionComponentState new_state)
	{
		state = new_state;
		targetIEC = iec;
	}
	
	/**
	 * @see org.eclipse.hyades.execution.core.IExecCompStateChangeEvent#newState()
	 */
	public IExecutionComponentState getState() {
		return state;
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecCompStateChangeEvent#targetExecutionComponent()
	 */
	public IExecutionComponent getTarget() {
		return targetIEC;
	}

}
