/**********************************************************************
Copyright (c) 2003 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/**
 *
 * <p>A session is the abstraction of a connection with a remote node.
 * Sessions are created by the node and are scoped by a Principal.
 * Therefore, a single workbench instance may have many sessions, one
 * for each Principal.  Tools access the session in context of a Principal,
 * when a tool is completed with a session it should release it so that the
 * reference count can be decremented.  Sessions are the highest level 
 * IExecutionComponent on the workbench side.</p>
 * @version 0.0.2
 */
public interface ISession extends IExecutionComponent {
	
	
	/**
	 * Create an execution environment in the context of this session.
	 * @param name The name of the execution environment
	 * @param type The type of execution environment to create
	 * @return The created IExecutionEnvironment
	 */
	public IExecutionEnvironment createExecutionEnvironment(String name, String type);
	
	/**
	 *  Release this session so that it can be cleaned up and destroyed
	 *  if no other tools are using it.
	 */ 
	public void release();

}
