/**********************************************************************
Copyright (c) 2003 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/** <p>IRemoteHyadesComponent defines an interface exposed by remote agents
 * that are capable of monitoring a running application.</p>
 * @version 0.0.2
 */
public interface IRemoteHyadesComponent extends IExecutionComponent {
	
	/**
	 * Determine whether this agent is currently active.
	 *
	 * @return whether this agent is currently active
	 */
	boolean isActive();
	
	/**
	 * Determine if this agent is currently being monitored.
	 *
	 * @return if this agent is currently being monitored
	 */
	boolean isMonitored();
	
	/**
	 * Determine is this agent is currently attached to a client.
	 *
	 * @return if this agent is currently attached to a client
	 */
	boolean isLocked();
	
	/** <p>The lock request will either succeed within the specified timeout, or
	 * will throw a TimeoutException.  If the IRemoteHyadesComponent supports
	 * multiple readers, it can allow multiple readers to have simultaneous locks.</p>
	 *
	 * @exception TimeoutException If the lock can not be acquired within the
	 *      specified timeout.
	 * @param timeout The number of milliseconds that during which the lock will
	 *      attempt to be acquired.
	 */
	public void lock( long timeout ) throws TimeoutException;
	
	/** Unlocks the component for use by other readers.
	 */
	public void unlock();
	
	
	
	/**
	 * <p>Start monitoring the data output of this IRemoteHyadesComponent using the specified
	 * DataProcessor.  You must be attached to the IRemoteHyadesComponent before you can
	 * start monitoring it.</p>
	 *
	 * @exception ExecutionComponentStateException if the remote hyades component
	 *      is not in a state that can accept this call.
	 * @param processor a reader to process the captured data
	 */
	void startMonitoring(IDataChannel processor) throws ExecutionComponentStateException;
	
	/**
	 * Stop monitoring this IRemoteHyadesComponent.
	 *
	 * @exception ExecutionComponentStateException if the remote hyades component
	 *      is not in a state that can accept this call.
	 */
	void stopMonitoring() throws ExecutionComponentStateException;
}

