/**********************************************************************
Copyright (c) 2003 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/** 
 * 
 * IExecutionEnvironment is a specialized IExecutionComponent that has
 * knowledge about the environment that the IExecutionComponent's and
 * its children reside within.
 * @version 0.0.2
 */
public interface IExecutionEnvironment extends IExecutionComponent {
	
	/** Get the entire environment as it is currently set.
	 * 
	 * @exception ExecutionComponentStateException 
	 * @return an array of IOrderedProperty objects
	 */
	public IOrderedProperty[] getEnv() throws ExecutionComponentStateException;
	
	/** Set the entire environment, overwriting an existing properties.
	 * 
	 * @exception ExecutionComponentStateException 
	 * @param env An array of IOrderedProperty objects to set the environment 
	 */
	public void setEnv(IOrderedProperty[] env) throws ExecutionComponentStateException;
	
	/** Add a property from the currently set environment
	 * 
	 * @exception ExecutionComponentStateException 
	 * @param env The property to add
	 */
	public void addEnv(IOrderedProperty env) throws ExecutionComponentStateException;
	
	/** Remove a property from the currently set environment
	 * 
	 * @exception ExecutionComponentStateException 
	 * @param name The name of the property to remove
	 */
	public IOrderedProperty removeProperty(String name) throws ExecutionComponentStateException;
	
	/** Creates an IExecutor object specific to this type of execution environment.
	 * The IExecutor object can be used to execute something within this
	 * IExecutionEnvironment.
	 * 
	 * @param name The name to be assigned to the IExecutor object.
	 * @exception ExecutionComponentStateException If the IExecutionEnvironment 
	 *     is dead or inactive
	 * @return an IExecutor object
	 */
	public IExecutor createExecutor(String name) throws ExecutionComponentStateException;
	
}
