/**********************************************************************
Copyright (c) 2003 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
	SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/**
 * This interface defines a factory for IExecutionComponents.  The mechanism by 
 * which this factory is extended to support multiple implementations of the 
 * same execution component type has not yet been resolved.
 * @version 0.0.2
 */
public interface IExecutionComponentFactory {
	
	/**
	 * @param type The type of execution component to create
	 * @return IExecutionComponent The created IExecutionComponent
	 */
	IExecutionComponent createExecutionComponentByType(String type);

}
