/**********************************************************************
Copyright (c) 2003 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/**
 * Representation of the state of an IExecutionComponent. At a miniumum,
 * state is represented by an integer value corresponding to the current
 * state, such as READY, SUSPENDED, DEAD, etc. The interface may be
 * extended to embed additional state information.
 */
public interface IExecCompStateChangeEvent {
	/**
	 * @return the current state of the associated IExecutionComponent
	 */
	public IExecutionComponentState getState();
	
	/**
	 * @return the IExecutionComponent whose state change is represented
	 * by this event.
	 */
	public IExecutionComponent getTarget();
}
