/**********************************************************************
Copyright (c) 2003 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
    SCAPA Technologies - initial implementation
**********************************************************************/

package org.eclipse.hyades.execution.core;

/** 
 * 
 * A ExecutionComponentStateException is thrown by any IExecutionComponent
 * operation that occurs when the IExecutionComponent is not in the correct
 * state to support the current operation.
 * @version 0.0.2
 */

public class ExecutionComponentStateException extends RuntimeException {
	
	private int state;
	
	/** 
	 * 
	 * @param state The state of the exception 
	 */
	public ExecutionComponentStateException(int state) {
		this.state=state;
	}
	
	/** 
	 * @return The state of the exception
	 */
	public int getState() {
		return state;
	}

}
