/**********************************************************************
Copyright (c) 2003 IBM Corporation and others.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
**********************************************************************/
package org.eclipse.hyades.execution.core;

/**
 * Simple execution state realization for an IExecutionComponent.
 * Suitable when state can be represented by an integral value. 
 */
public class ExecutionComponentState implements IExecutionComponentState {
	/* Predefined execution states */
	public static final int INACTIVE = 0; 
	public static final int READY = 1; 
	public static final int SUSPENDED = 2; 
	public static final int DEAD = 3; 
	
	protected int value;
	
	public ExecutionComponentState() {
		value = INACTIVE;
	}

	public ExecutionComponentState(int initialState) {
		value = initialState;
	}
	
	public int getValue() {
		return value;
	}
}
