/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.security;

import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.common.ServerSecurityInfoCommand;

/**
 * @author rduggan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class SecureConnectionRequiredException
	extends AgentControllerUnavailableException {
		
		ServerSecurityInfoCommand _details;
		
		public SecureConnectionRequiredException(ServerSecurityInfoCommand command) {
			_details=command;
		}
		
		public boolean isPasswordProtected() {
			return _details.isPasswordProtected();
		}
		
		public boolean isClientAuthenticationRequired() {
			return _details.isClientAuthenticationRequired();
		}
		
		public long getSecurePort() {
			return _details.getSecurePort();	
		}

}
