/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.control;


public class ContextMapper {
	protected final static int MAPPING_INCREMENT =10;

	protected ContextMap[] _map=new ContextMap[MAPPING_INCREMENT];
	protected int _mappingCount=0;
	protected int _maxMappingCount=0;


	class ContextMap {
		public long _context=0;
		public CommandHandler _handler=null;
		public boolean _dirty=false;
	}

	public ContextMapper() {
		super();
	}

	public void addContext(long contextId, CommandHandler handler) {
		synchronized(_map) {
			if(_maxMappingCount == _map.length) {
				increaseContextmappingCapacity();
			}
			for(int i=_mappingCount; i>=0; i--) {
				if(_map[i]==null) {
					_mappingCount++;
					_maxMappingCount++;
					_map[i]=new ContextMap();
					_map[i]._context=contextId;
					_map[i]._handler=handler;
					_map[i]._dirty=true;
					return;
				}
				else if(!_map[i]._dirty) {
					_mappingCount++;
					_map[i]._context=contextId;
					_map[i]._handler=handler;
					_map[i]._dirty=true;
					return;
				}
			}
		}
	}

	public CommandHandler getHandler(long contextid) {
		CommandHandler ch=null;
		synchronized (_map) {
			for(int i=_maxMappingCount-1; i>=0; i--) {
				if(_map[i]==null) {
					/* This should never happen */
					break;
				}
				if(_map[i]._context==contextid && _map[i]._dirty==true ) {
					ch=_map[i]._handler;
					break;
				}
			}
		}
		return ch;
	}

	protected void increaseContextmappingCapacity() {
		synchronized(_map) {
			ContextMap[] newMapper=new ContextMap[_maxMappingCount+MAPPING_INCREMENT];
			for(int i=0; i<_maxMappingCount; i++) {
				newMapper[i]=_map[i];
			}
			_map=newMapper;
			newMapper=null;
		}
	}

	public void removeContext(long contextId) {
		synchronized (_map) {
			for(int i=_maxMappingCount-1; i>=0; i--) {
				if(_map[i]._context==contextId && _map[i]._dirty==true ) {
					_mappingCount--;
					_map[i]._dirty=false;
					_map[i]._handler=null;
					break;
				}
			}
		}	
	
	}
}
