/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.security.User;
import org.eclipse.hyades.internal.execution.security.AuthenticationListener;

public interface Connection {
	
	void sendMessage(ControlMessage msg, CommandHandler handler) throws IOException;
	
	void disconnect();
	
	Node getNode();

	boolean isActive();
	
	int getPort();
	
	
	/**
	 * Adds a ConnectionListener to this Connection instance.
	 * @see ConnectionListener
	 */
	void addConnectionListener(ConnectionListener listener);
	
	/**
	 * Removes a ConnectionListener from this Connection instance.
	 * @see ConnectionListener
	 */
	void removeConnectionListener(ConnectionListener listener);
	
	
	/**
	 * Adds an AuthenticationListener to this connection.
	 * @see AuthenticationListener
	 */
	void addAuthenticationListener(AuthenticationListener listener);
	
	/**
	 * Removes an AuthenticationListener from this connection.
	 * @see AuthenticationListener
	 */
	void removeAuthenticationListener(AuthenticationListener listener);

}

