/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

/**
 * @author rduggan
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class ServerSecurityInfoCommand extends CommandElement implements Constants {

	long _flag;
	long _port;
	
	
	public ServerSecurityInfoCommand() {
		super();
		_tag=RA_SERVER_SECURITY_REQUIREMENTS;
	}
	
	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#getSize()
	 */
	public int getSize() {
		return 2*sizeofLong;
	}
	
	public long getSecurePort() {
		return _port;
	}
	
	public boolean isPasswordProtected() {
		return _flag<3;
	}
	
	public boolean isClientAuthenticationRequired() {
		return _flag>1;	
	}

	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#readFromBuffer(byte[], int)
	 */
	public int readFromBuffer(byte[] buffer, int offset) {
		int current=offset;
		_flag=Message.readRALongFromBuffer(buffer, current);
		current+=sizeofLong;
		_port=Message.readRALongFromBuffer(buffer, current);
		current+=sizeofLong;
		return current;
	}

	/**
	 * @see org.eclipse.hyades.internal.execution.local.common.CommandElement#writeToBuffer(byte[], int)
	 */
	public int writeToBuffer(byte[] buffer, int offset) {
		int current=offset;
		current=Message.writeRALongToBuffer(buffer, current, _tag);
		current=Message.writeRALongToBuffer(buffer, current, _flag);
		current=Message.writeRALongToBuffer(buffer, current, _port);
		
		return current;
	}

}
