/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.internal.execution.local.common;

import java.util.Vector;
/**
 * Insert the type's description here.
 * Creation date: (6/2/00 12:57:48 PM)
 * @author: Administrator
 */
public class LaunchProcessCommand extends CommandElement implements Constants {

	protected RAString	_args=new RAString("");
	protected RAString	_exe=new RAString("");
	protected RAString  _location=new RAString("");
	protected long		_consoleIP=0;
	protected long		_consolePort=0;
	protected Vector	_environment=new Vector();
	protected Vector	_agents=new Vector();
/**
 * StartVMCommandEntry constructor comment.
 */
public LaunchProcessCommand() {
	super();
	_tag=RA_LAUNCH_PROCESS;
}
/**
 * Insert the method's description here.
 * Creation date: (9/19/00 2:06:59 AM)
 * @param name java.lang.String
 */
public void addAgent(String name) {
	_agents.addElement(new RAString(name));
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/00 7:42:56 PM)
 * @param name java.lang.String
 * @param value java.lang.String
 */
public void addEnvironmentVariable(String name, String value) {
	_environment.addElement(new RAString(name+"="+value));
}
/**
 * Insert the method's description here.
 * Creation date: (6/2/00 12:59:18 PM)
 * @return java.lang.String
 */
public String getArgs() {
	if (_args != null)
		return _args.getData();
	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (9/11/00 8:58:33 PM)
 * @return java.lang.String
 */
public String getExe() {
	if (_exe != null)
		return _exe.getData();

	return null;
}
/**
 * Insert the method's description here.
 * Creation date: (6/8/00 1:00:36 PM)
 * @return int
 */
public int getSize() {
	int size=4*sizeofLong+_exe.getSize()+_args.getSize()+_location.getSize()+2*sizeofLong;
	for(int i=0; i<_agents.size(); i++) {
		size+=((RAString)_agents.elementAt(i)).getSize();
	}
	for(int i=0; i<_environment.size(); i++) {
		size+=((RAString)_environment.elementAt(i)).getSize();
	}
	
	return size;
}
/**
 * Insert the method's description here.
 * Creation date: (9/11/00 10:20:50 PM)
 * @return int
 * @param buffer byte[]
 * @param offset int
 */
public int readFromBuffer(byte[] buffer, int offset) {
	int current=offset;
	_context=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;

	_consoleIP=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;

	_consolePort=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;

	current=Message.readRAStringFromBuffer(buffer, current, _exe);
	current=Message.readRAStringFromBuffer(buffer, current, _args);
	current=Message.readRAStringFromBuffer(buffer, current, _location);
	
	
	long listLength=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;
	for(int i=0; i<listLength; i++) {
		RAString envVar=null;
		current=Message.readRAStringFromBuffer(buffer, current, envVar);
		_agents.addElement(envVar);
	}

	listLength=Message.readRALongFromBuffer(buffer, current);
	current+=sizeofLong;
	for(int i=0; i<listLength; i++) {
		RAString envVar=null;
		current=Message.readRAStringFromBuffer(buffer, current, envVar);
		_environment.addElement(envVar);
	}
	
	return current;

}
/**
 * Insert the method's description here.
 * Creation date: (6/2/00 1:00:01 PM)
 * @param args java.lang.String
 */
public void setArgs(String args) {
	_args=new RAString(args);
}
/**
 * Insert the method's description here.
 * Creation date: (2/19/01 3:12:52 PM)
 * @param console org.eclipse.hyades.internal.execution.local.common.Console
 */
public void setConsole(Console console) throws ConsoleNotStartedException {
	_consoleIP=console.getIP();
	_consolePort=console.getPort();
	
}
/**
 * Insert the method's description here.
 * Creation date: (9/11/00 8:58:07 PM)
 * @param exe java.lang.String
 */
public void setExe(String exe) {
	_exe=new RAString(exe);
}


public void setLocation(String location) {
	_location=new RAString(location);
}
/**
 * Insert the method's description here.
 * Creation date: (7/21/00 2:36:20 PM)
 * @return int
 * @param buffer byte[]
 * @param offset int
 */
public int writeToBuffer(byte[] buffer, int offset) {
	int current=offset;

	current=Message.writeRALongToBuffer(buffer, current, _tag);
	current=Message.writeRALongToBuffer(buffer, current, _context);
	current=Message.writeRALongToBuffer(buffer, current, _consoleIP);
	
	current=Message.writeRALongToBuffer(buffer, current, _consolePort);
	
	current=Message.writeRAStringToBuffer(buffer, current, _exe);
	current=Message.writeRAStringToBuffer(buffer, current, _args);
	current=Message.writeRAStringToBuffer(buffer, current, _location);
	
	current=Message.writeRALongToBuffer(buffer, current, (long)_environment.size());
	for(int i=0; i<_environment.size(); i++) {
		current=Message.writeRAStringToBuffer(buffer, current, ((RAString)_environment.elementAt(i)));
	}
	current=Message.writeRALongToBuffer(buffer, current, (long)_agents.size());
	for(int i=0; i<_agents.size(); i++) {
		current=Message.writeRAStringToBuffer(buffer, current, ((RAString)_agents.elementAt(i)));
	}
	
	return current;
}
}
