package org.eclipse.hyades.execution.local;
/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * Scapa - Initial API and implementation
 **********************************************************************/

import java.util.Enumeration;

import org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener;
import org.eclipse.hyades.execution.core.ISession;
import org.eclipse.hyades.execution.core.INode;
import org.eclipse.hyades.execution.core.IExecutionEnvironment;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;


public class LocalSession extends LocalExecutionComponent implements ISession {

private static final boolean DEBUG = true;

	/* Our INode that our session belongs to. */
	INode node=null;
	
	/* The remote agent that allows to communicate with the remote session. */
	Agent agent=null;

	public LocalSession(INode node, Agent agent) {
		super("Session", "org.eclipse.hyades.execution.local.LocalSession", null, node);
		this.node=node;
		this.agent=agent;
		createAgentListener();
	}
	
	/**
	 * @see 
	 */
	public IExecutionEnvironment createExecutionEnvironment(String name, String type) {
		Exception e = new Exception("WARNING:unimplemented");
		e.printStackTrace();
		return null;
	}

	/**
	 * @see 
	 */
	public void release() {
		Exception e = new Exception("WARNING:unimplemented");
		e.printStackTrace();
	}
	
	/**
	 * This creates a agent listener for the embedded agent on the remote session.  
	 * This listener is responsible for firing state change events and forwarding 
	 * all the commands to the proper handler.
	 *
	 */
	private void createAgentListener() {
		agent.addAgentListener(new AgentListener() {

			public void agentActive(Agent agent) {
				/* Notify our listeners that the state has changed */
				fireStateChange(READY);
			}

			public void agentInactive(Agent agent) {
				/* Notify our listeners that the state has changed */
				fireStateChange(READY);
			}

			public void error(Agent agent, String errorId, String errorMessage) {
				// TODO Auto-generated method stub
				
			}

			public void handleCommand(Agent agent, CommandElement command) {
				// TODO Auto-generated method stub
				
			}	
		});
		
	}
	
	/****  ADDITIONAL METHODS THAT SHOULD BE IN INTERFACE   ************************/
	
	/**
	 * We need to be able to navigate back to our node.
	 * 
	 */
	public INode getNode() {
		return node;
	}
	
	/**
	 * Fire a state change event.  This should be in the interface because
	 * the behaviour of how to fire the event is tightly coupled with the 
	 * data structure used to hold the listeners.
	 * 
	 * @param newState
	 */
	public void fireStateChange(int newState) {
		synchronized(stateChangeListeners) {
			state=newState;
			Enumeration e=stateChangeListeners.elements();
			while(e.hasMoreElements()) {
				IExecutionComponentStateChangeListener listener=(IExecutionComponentStateChangeListener)e.nextElement();
				listener.stateChanged(newState);
			}
		}
	}

}