package org.eclipse.hyades.execution.local;

import java.util.ArrayList;
import java.util.Vector;

import org.eclipse.hyades.execution.core.*;

public class LocalExecutionComponent implements IExecutionComponent {
	
	protected int state = INACTIVE;
	
	private static int statid = 0;
	private static synchronized String getNextID() {
		statid++;
		return ""+statid;
	}
	
	String name = "";
	String type = "";
	String myid = "";
	IExecutionComponent parent;
	INode node;
	
	ArrayList child_list = new ArrayList();
	
	protected Vector stateChangeListeners = new Vector();

	LocalExecutionComponent(String name, String type, IExecutionComponent parent, INode node) {
		this.name = name;
		this.type = type;
		this.parent = parent;
		this.node = node;
		myid = getNextID();
	}
	
	/** 
	 * All IExecutionComponent instances must have an immutable
	 * name.  Names are user friendly identifiers.
	 * 
	 * @return the name of the IExecutionComponent
	 */
	public String getName() {
		return name;
	}
	
	/** 
	 * All IExecutionComponent instances must have an immutable
	 * ID. Id's are globaly unique values that identify this unique
	 * IExecutionComponent runtime instance.
	 * 
	 * @return The ID of the IExecutionComponent
	 */
	public String getId(){
		return myid;
	}
	
	/** 
	 * All IExecutionComponent instances must have an immutable
	 * type. The type field is intended to allow you to identify groups
	 * of IExecutionComponent instances as having the same behaviour.
	 * 
	 * @return the type of the IExecutionComponent
	 */
	public String getType() {
		return type;
	}
	
	/** 
	 * Retrieve the version.
	 */
	public String getVersion() {
		return "0.0.1";
	}
	
	/** 
	 * Get the container where this IExecutionComponent
	 * is hosted.  The typical heirarchy is a follows:
	 * ISession->IExecutor->IRemoteHyadesComponent
	 * It is possible, however, to have any level of nesting here.
	 * The ISession is always the root.
	 */
	public IExecutionComponent getParent() {
		return parent; 
	}
	
	/** 
	 * Get the first-level children that reside under this IExecutionComponent
	 * The typical heirarchy is a follows:
	 * ISession->IExecutor->IRemoteHyadesComponent
	 * It is possible, however, to have any level of nesting here.
	 * The ISession is always the root.
	 */
	public IExecutionComponent[] getChildren() {
		return (IExecutionComponent[])child_list.toArray();
	}
	
	
	/** 
	 * Retrieve all of the first-level children of a specific type.
	 */
	public IExecutionComponent[] getChildren(String  type) {
		
		Object[] children = child_list.toArray();
		ArrayList tchildren = new ArrayList();
		
		for (int i = 0; i < children.length; i++) {
			IExecutionComponent tmp = (IExecutionComponent)children[i];
			if (tmp.getType().equals(type)) {
				tchildren.add(tmp);
			}
		}
		
		return (IExecutionComponent[])tchildren.toArray();
	}

	/**
	 * Retrieve all of the first-level children of a specific type in the specified state.
	 */
	public IExecutionComponent[] getChildren(String type, int state) {

		Exception e = new Exception("ERROR:no such defined thing as \"int state\" - we represent states in methods, not in integers ");
		e.printStackTrace();
		
		Object[] children = child_list.toArray();
		ArrayList tchildren = new ArrayList();
			
		for (int i = 0; i < children.length; i++) {
			IExecutionComponent tmp = (IExecutionComponent)children[i];
//			if (tmp.getType().equals(type) && tmp.getState() == state) {
			if (tmp.getType().equals(type)) {
				tchildren.add(tmp);
			}
		}
			
		return (IExecutionComponent[])tchildren.toArray();
	}
	
	/** 
	 * Retrieve a child of this IExecutionComponent based upon its
	 * ID.
	 */
	public IExecutionComponent getChildById(String id) {
		for (int i = 0; i < child_list.size(); i++) {
			IExecutionComponent tmp = (IExecutionComponent)child_list.get(i);
			if (id.equals(tmp.getId())) {
				return tmp;	
			}
		}
		return null;
	}
	
	/** 
	 * Retrieve a child of this IExecutionComponent based upon its
	 * name.
	 * RKD:  This may not be the best idea due to name collision
	 * issues.  probably want to stick to just ID's.
	 * 
	 * @param name 
	 */
	public IExecutionComponent getChildByName(String name) {
		for (int i = 0; i < child_list.size(); i++) {
			IExecutionComponent tmp = (IExecutionComponent)child_list.get(i);
			if (name.equals(tmp.getName())) {
				return tmp;	
			}
		}
		return null;
	}
	
	/** 
	 * Create an child
	 * 
	 * @param id ID of the child IExecutionComponent
	 * @param name Name of the child IExecutionComponent
	 * @param type Type of the child IExecutionComponent
	 * @return the child IExecutionComponent
	 */
	public IExecutionComponent createChild(String id, String name, String type) {
		Exception e = new Exception("ERROR: same as addChild(id,name,type)?");
		e.printStackTrace();
		return null;
	}

	/** 
	 * Add a child
	 * 
	 * @param id ID of the child IExecutionComponent
	 * @param name Name of the child IExecutionComponent
	 * @param type Type of the child IExecutionComponent
	 */
	public void addChild(String id, String name, String type) {
		Exception e = new Exception("ERROR: same as createChild(id,name,type)? - where do I get actual child from?");
		e.printStackTrace();
	}


	/** 
	 * Get the node on which this IExecutionComponent resides.
	 * 
	 * @return the node on which this IExecutionComponent resides
	 */
	public INode getNode() {
		return node;
	}
		
	/** 
	 * Whether this IExecutionComponent is in the inactive state
	 */
	public boolean isInactive() {
		return state == INACTIVE;
	}
	
	/** 
	 * Whether this IExecutionComponent is in the ready state
	 */
	public boolean isReady() {
		return state == READY;
	}
	
	/** 
	 * Whether this IExecutionComponent is in the suspend state
	 */
	public boolean isSuspended() {
		return state == SUSPENDED;
	}
	
	/** 
	 * Whether this IExecutionComponent is in the dead state
	 */
	public boolean isDead() {
		return state == DEAD;
	}

	/** 
	 * @see org.eclipse.hyades.execution.core.IExecutionComponent#addExecutionComponentStateChangeListener(org.eclipse.hyades.execution.core.IExecutionComponentStateChangeListener)
	 */
	public void addExecutionComponentStateChangeListener(IExecutionComponentStateChangeListener listener) {
		
		synchronized(stateChangeListeners) {
			stateChangeListeners.add(listener);
		}
		
		
	}
}
