/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.eclipse.hyades.internal.execution.local.control.ConnectionImpl;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.security.LoginFailedException;
import org.eclipse.hyades.internal.execution.security.SecureConnectionRequiredException;
import org.eclipse.hyades.internal.execution.security.UntrustedAgentControllerException;

class SecureConnectionImpl
extends ConnectionImpl {
    public void connect(Node node, int n) throws IOException, SecureConnectionRequiredException, LoginFailedException, UntrustedAgentControllerException {
        this._port = n;
        int n2 = 0;
        InetAddress[] inetAddressArray = node.getAllInetAddresses();
        String[] stringArray = new String[]{"SSL", "SSL_TLS", "TLS", "SSLv2", "SSLv3", "TLSv1"};
        int n3 = 0;
        do {
            try {
                SSLContext sSLContext = SSLContext.getInstance(stringArray[n3]);
                sSLContext.init(node.getKeystoreManager().getKeyManagers(), node.getKeystoreManager().getTrustManagers(), null);
                if (sSLContext == null) {
                    Security.addProvider(node.getKeystoreManager().getProvider());
                    this._socket = SSLSocketFactory.getDefault().createSocket(inetAddressArray[n2], n);
                    ((SSLSocket)this._socket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                        }
                    });
                    ((SSLSocket)this._socket).startHandshake();
                } else {
                    this._socket = sSLContext.getSocketFactory().createSocket(inetAddressArray[n2], n);
                    ((SSLSocket)this._socket).addHandshakeCompletedListener(new HandshakeCompletedListener(){

                        public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
                        }
                    });
                }
                SSLSession sSLSession = ((SSLSocket)this._socket).getSession();
                if (sSLSession == null) {
                    throw new UntrustedAgentControllerException();
                }
                break;
            }
            catch (ConnectException connectException) {
                if (++n2 == inetAddressArray.length) {
                    throw connectException;
                }
                n3 = 0;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                if (++n3 != stringArray.length) continue;
                throw new ConnectException("Could not get an SSLContext. All protocol specifications were tried");
            }
            catch (KeyManagementException keyManagementException) {
                // empty catch block
            }
        } while (n2 < inetAddressArray.length);
        this._node = node;
        this.init();
    }
}

