/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.control;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.hyades.internal.execution.local.common.AttachToAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.CommandElement;
import org.eclipse.hyades.internal.execution.local.common.ControlMessage;
import org.eclipse.hyades.internal.execution.local.common.CustomCommand;
import org.eclipse.hyades.internal.execution.local.common.DataProcessor;
import org.eclipse.hyades.internal.execution.local.common.DetachFromAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.ErrorCommand;
import org.eclipse.hyades.internal.execution.local.common.MonitorPeerRequestCommand;
import org.eclipse.hyades.internal.execution.local.common.SetNVPairCommand;
import org.eclipse.hyades.internal.execution.local.common.StartMonitoringRemoteAgentCommand;
import org.eclipse.hyades.internal.execution.local.common.StopMonitorCommand;
import org.eclipse.hyades.internal.execution.local.common.TCPDataServer;
import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.AgentConfiguration;
import org.eclipse.hyades.internal.execution.local.control.AgentConfigurationEntry;
import org.eclipse.hyades.internal.execution.local.control.AgentControllerUnavailableException;
import org.eclipse.hyades.internal.execution.local.control.AgentListener;
import org.eclipse.hyades.internal.execution.local.control.AgentPeerListener;
import org.eclipse.hyades.internal.execution.local.control.CommandHandler;
import org.eclipse.hyades.internal.execution.local.control.InactiveAgentException;
import org.eclipse.hyades.internal.execution.local.control.InactiveProcessException;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.internal.execution.local.control.NodeFactory;
import org.eclipse.hyades.internal.execution.local.control.NotConnectedException;
import org.eclipse.hyades.internal.execution.local.control.Process;
import org.eclipse.hyades.internal.execution.local.control.ProcessImpl;
import org.eclipse.hyades.internal.execution.local.control.ProcessListener;

public class AgentImpl
implements Agent,
ProcessListener {
    protected String _name = null;
    protected String _type = null;
    protected String _uuid = null;
    protected Process _process = null;
    protected AgentConfiguration _config;
    protected boolean _autoAttach = false;
    protected boolean _isMonitored = false;
    protected boolean _isActive = false;
    protected boolean _isAttached = false;
    protected TCPDataServer _server = null;
    protected String _profileFile = null;
    protected Vector _listeners = new Vector(10);

    public AgentImpl(Process process, String string) {
        this(process, string, null);
    }

    public AgentImpl(Process process, String string, String string2) {
        this(process, string, string2, false);
    }

    public AgentImpl(Process process, String string, String string2, boolean bl) {
        this._process = process;
        this._name = string;
        this._type = string2;
        this._isActive = bl;
        process.addProcessListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAgentListener(AgentListener agentListener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (!this._listeners.contains(agentListener)) {
                this._listeners.add(agentListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAgentListener(AgentListener agentListener) {
        Vector vector = this._listeners;
        synchronized (vector) {
            if (this._listeners.contains(agentListener)) {
                this._listeners.remove(agentListener);
            }
        }
    }

    public Process getProcess() {
        return this._process;
    }

    public void setAutoAttach(boolean bl) {
        this._autoAttach = bl;
    }

    public boolean isAutoAttach() {
        return this._autoAttach;
    }

    public void attach() throws InactiveAgentException, InactiveProcessException {
        this._isAttached = true;
        ControlMessage controlMessage = new ControlMessage();
        AttachToAgentCommand attachToAgentCommand = new AttachToAgentCommand();
        attachToAgentCommand.setAgentName(this._name);
        attachToAgentCommand.setProcessId(Long.valueOf(this.getProcess().getProcessId()));
        controlMessage.appendCommand(attachToAgentCommand);
        try {
            this._process.getNode().getConnection().sendMessage(controlMessage, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement commandElement) {
                    AgentImpl.this.handleCommand(commandElement);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void detach() throws InactiveAgentException, InactiveProcessException {
        this._isAttached = false;
        this.stopMonitoring();
        ControlMessage controlMessage = new ControlMessage();
        DetachFromAgentCommand detachFromAgentCommand = new DetachFromAgentCommand();
        detachFromAgentCommand.setAgentName(this._name);
        detachFromAgentCommand.setProcessId(Long.valueOf(this.getProcess().getProcessId()));
        controlMessage.appendCommand(detachFromAgentCommand);
        try {
            this._process.getNode().getConnection().sendMessage(controlMessage, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement commandElement) {
                    AgentImpl.this.handleCommand(commandElement);
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getType() {
        return this._type;
    }

    public String getName() {
        return this._name;
    }

    public String getUUID() {
        return this._uuid;
    }

    public boolean isActive() {
        return this._isActive;
    }

    public boolean isMonitored() {
        return this._isMonitored;
    }

    public boolean isAttached() {
        return this._isAttached;
    }

    public void startMonitoring(DataProcessor dataProcessor) throws InactiveAgentException {
        if (!this._isAttached) {
            return;
        }
        if (this._server == null) {
            this._server = new TCPDataServer();
        }
        try {
            this._server.startServer(dataProcessor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ControlMessage controlMessage = new ControlMessage();
        StartMonitoringRemoteAgentCommand startMonitoringRemoteAgentCommand = new StartMonitoringRemoteAgentCommand();
        startMonitoringRemoteAgentCommand.setAgentName(this._name);
        startMonitoringRemoteAgentCommand.setPort((short)this._server.getPort());
        try {
            startMonitoringRemoteAgentCommand.setProcessId(Long.parseLong(this._process.getProcessId()));
            controlMessage.appendCommand(startMonitoringRemoteAgentCommand);
            this._process.getNode().getConnection().sendMessage(controlMessage, null);
        }
        catch (InactiveProcessException inactiveProcessException) {
            throw new InactiveAgentException();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._isMonitored = true;
    }

    public void stopMonitoring() throws InactiveAgentException {
        if (this._server != null) {
            this._server.stopServer();
            this._server = null;
        }
        if (!this._isMonitored) {
            return;
        }
        ControlMessage controlMessage = new ControlMessage();
        StopMonitorCommand stopMonitorCommand = new StopMonitorCommand();
        stopMonitorCommand.setAgentName(this._name);
        try {
            stopMonitorCommand.setProcessId(Long.parseLong(this._process.getProcessId()));
            controlMessage.appendCommand(stopMonitorCommand);
            this._process.getNode().getConnection().sendMessage(controlMessage, null);
        }
        catch (InactiveProcessException inactiveProcessException) {
            throw new InactiveAgentException();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._isMonitored = false;
    }

    public void setConfiguration(AgentConfiguration agentConfiguration) {
        this._config = agentConfiguration;
    }

    public AgentConfiguration getConfiguration() {
        if (this._config == null) {
            this._config = new AgentConfiguration();
        }
        return this._config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishConfiguration() throws InactiveAgentException {
        if (!this._isActive) {
            throw new InactiveAgentException();
        }
        if (this._config == null) {
            return;
        }
        int n = 0;
        ControlMessage controlMessage = new ControlMessage();
        AgentConfiguration agentConfiguration = this._config;
        synchronized (agentConfiguration) {
            int n2 = 0;
            while (n2 < this._config.size()) {
                AgentConfigurationEntry agentConfigurationEntry = this._config.getEntryAt(n2);
                if (agentConfigurationEntry != null && agentConfigurationEntry.isEnabled()) {
                    ++n;
                    SetNVPairCommand setNVPairCommand = new SetNVPairCommand();
                    try {
                        setNVPairCommand.setProcessId(Long.parseLong(this._process.getProcessId()));
                    }
                    catch (InactiveProcessException inactiveProcessException) {
                        throw new InactiveAgentException();
                    }
                    setNVPairCommand.setAgentName(this._name);
                    setNVPairCommand.setType(agentConfigurationEntry.getType());
                    setNVPairCommand.setName(agentConfigurationEntry.getName());
                    setNVPairCommand.setValue(agentConfigurationEntry.getValue());
                    controlMessage.appendCommand(setNVPairCommand);
                }
                ++n2;
            }
        }
        if (n > 0) {
            try {
                this._process.getNode().getConnection().sendMessage(controlMessage, null);
            }
            catch (InactiveProcessException inactiveProcessException) {
                throw new InactiveAgentException();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void invokeCustomCommand(CustomCommand customCommand) throws InactiveAgentException {
        if (!this._isActive) {
            throw new InactiveAgentException();
        }
        ControlMessage controlMessage = new ControlMessage();
        controlMessage.appendCommand(customCommand);
        customCommand.setAgentName(this._name);
        try {
            customCommand.setProcessId(Long.parseLong(this._process.getProcessId()));
            this._process.getNode().getConnection().sendMessage(controlMessage, new CommandHandler(){

                public void incommingCommand(Node node, CommandElement commandElement) {
                    AgentImpl.this.handleCommand(commandElement);
                }
            });
        }
        catch (InactiveProcessException inactiveProcessException) {
            throw new InactiveAgentException();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setUUID(String string) {
        this._uuid = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCommand(final CommandElement commandElement) {
        switch ((int)commandElement.getTag()) {
            case 35: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    this._isActive = true;
                    if (this._autoAttach) {
                        this._isAttached = true;
                    }
                    Enumeration enumeration = this._listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((AgentListener)enumeration.nextElement()).agentActive(this);
                    }
                    break;
                }
            }
            case 36: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    this._isActive = false;
                    Enumeration enumeration = this._listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((AgentListener)enumeration.nextElement()).agentInactive(this);
                    }
                    break;
                }
            }
            case 37: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    Enumeration enumeration = this._listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((AgentListener)enumeration.nextElement()).error(this, ((ErrorCommand)commandElement).getErrorId(), ((ErrorCommand)commandElement).getErrorString());
                    }
                    break;
                }
            }
            case 98: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    try {
                        InetAddress inetAddress = ((MonitorPeerRequestCommand)commandElement).getPeerNode();
                        if (inetAddress != null) {
                            final Node node = NodeFactory.createNode(inetAddress.getHostAddress());
                            if (!node.isConnected()) {
                                node.connect(10002);
                            }
                            final AgentImpl agentImpl = this;
                            Runnable runnable = new Runnable(){

                                public void run() {
                                    String string = Long.toString(((MonitorPeerRequestCommand)commandElement).getProcessId());
                                    Enumeration enumeration = null;
                                    try {
                                        enumeration = node.listProcesses();
                                    }
                                    catch (NotConnectedException notConnectedException) {
                                        // empty catch block
                                    }
                                    Process process = null;
                                    while (enumeration.hasMoreElements()) {
                                        process = (Process)enumeration.nextElement();
                                        try {
                                            if (process.getProcessId().equals(string)) break;
                                            process = null;
                                        }
                                        catch (InactiveProcessException inactiveProcessException) {
                                            // empty catch block
                                        }
                                    }
                                    if (process == null) {
                                        return;
                                    }
                                    Agent agent = process.getAgent(((MonitorPeerRequestCommand)commandElement).getAgentName());
                                    if (agent == null) {
                                        return;
                                    }
                                    Enumeration enumeration2 = AgentImpl.this._listeners.elements();
                                    while (enumeration2.hasMoreElements()) {
                                        AgentListener agentListener = (AgentListener)enumeration2.nextElement();
                                        if (!(agentListener instanceof AgentPeerListener)) continue;
                                        ((AgentPeerListener)agentListener).peerWaiting(agentImpl, agent);
                                    }
                                }
                            };
                            Thread thread = new Thread(runnable, "PeerDelegate");
                            thread.start();
                        }
                    }
                    catch (UnknownHostException unknownHostException) {
                    }
                    catch (AgentControllerUnavailableException agentControllerUnavailableException) {
                        // empty catch block
                    }
                    break;
                }
            }
            case 41: {
                try {
                    ProcessImpl processImpl = (ProcessImpl)this.getProcess();
                    processImpl.handleCommand(commandElement);
                }
                catch (ClassCastException classCastException) {}
                break;
            }
            default: {
                Vector vector = this._listeners;
                synchronized (vector) {
                    Enumeration enumeration = this._listeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((AgentListener)enumeration.nextElement()).handleCommand(this, commandElement);
                    }
                    break;
                }
            }
        }
    }

    public void processLaunched(Process process) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processExited(Process process) {
        if (process == this._process && this._isActive) {
            Vector vector = this._listeners;
            synchronized (vector) {
                this._isActive = false;
                Enumeration enumeration = this._listeners.elements();
                while (enumeration.hasMoreElements()) {
                    ((AgentListener)enumeration.nextElement()).agentInactive(this);
                }
            }
        }
    }

    public boolean isToProfileFile() {
        return this._profileFile != null && this._profileFile.trim().length() != 0;
    }

    public String getProfileFile() {
        return this._profileFile;
    }

    public void setProfileFile(String string) {
        this._profileFile = string;
    }
}

