/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import org.eclipse.hyades.internal.execution.local.common.Constants;

class RAString
implements Constants {
    protected String _data = "";
    protected int _padding = 0;

    public RAString() {
    }

    public RAString(String string) {
        if (string != null) {
            this._data = string;
            this.calculatePadding();
        } else {
            this._data = "";
            this._padding = 0;
        }
    }

    private void calculatePadding() {
        block3: {
            try {
                this._padding = 4 - this._data.getBytes("UTF-8").length % 4;
                if (this._padding == 4) {
                    this._padding = 0;
                }
            }
            catch (Exception exception) {
                this._padding = 4 - this._data.length() % 4;
                if (this._padding != 4) break block3;
                this._padding = 0;
            }
        }
    }

    public String getData() {
        return this._data;
    }

    public int getPadding() {
        return this._padding;
    }

    public int getSize() {
        try {
            return 4 + this._data.getBytes("UTF-8").length + this._padding;
        }
        catch (Throwable throwable) {
            return 4 + this._data.length() + this._padding;
        }
    }

    public long length() {
        if (this._data != null) {
            return this._data.length();
        }
        return 0L;
    }

    public void setData(String string) {
        this._data = string;
        this.calculatePadding();
    }
}

