/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.internal.execution.local.common;

import org.eclipse.hyades.internal.execution.local.common.Constants;

class RABinaryArray
implements Constants {
    protected byte[] _data;
    protected int _padding = 0;

    public RABinaryArray() {
    }

    public RABinaryArray(byte[] byArray) {
        if (byArray != null) {
            this._data = byArray;
            this.calculatePadding();
        } else {
            this._padding = 0;
        }
    }

    private void calculatePadding() {
        this._padding = 4 - this._data.length % 4;
        if (this._padding == 4) {
            this._padding = 0;
        }
    }

    public byte[] getData() {
        return this._data;
    }

    public int getPadding() {
        return this._padding;
    }

    public int getSize() {
        return 4 + this._data.length + this._padding;
    }

    public long length() {
        if (this._data != null) {
            return this._data.length;
        }
        return 0L;
    }

    public void setData(byte[] byArray) {
        this._data = byArray;
        this.calculatePadding();
    }

    public void setData(byte[] byArray, int n, int n2) {
        if (byArray != null) {
            this._data = new byte[n2];
            System.arraycopy(byArray, n, this._data, 0, n2);
            this.calculatePadding();
        }
    }
}

