/**
 * TODO: Copyright
 */
package org.eclipse.higgins.framework.idas;

import java.net.URI;
import java.util.Set;

/**
 * As defined at <a href="http://spwiki.editme.com/Context">http://spwiki.editme.com/Context</a> and <a href="http://spwiki.editme.com/ContextProvider">http://spwiki.editme.com/ContextProvider</a>, This interface holds a set of {@link IDigitalSubject} objects.<p>
 * 
 * TODO: Support update and deletion of attributes of contained Digital Subjects as allowed by the context's policy <a href="http://spwiki.editme.com/ContextProvider#IContextR3">(R3 at http://spwiki.editme.com/ContextProvider)</a>. I (Jimse) think this should be the responsibility of an IDigitalSubject.<br>
 * TODO: Provide the ability to export and import the contents of a context to an RDF data stream <a href="http://spwiki.editme.com/ContextProvider#IContextR4">(R4 at http://spwiki.editme.com/ContextProvider)</a><br>
 * TODO: Act as a container of references to sub-Contexts <a href="http://spwiki.editme.com/ContextProvider#IContextR5">(R5 at http://spwiki.editme.com/ContextProvider)</a><br>
 * TODO: Maintain (and return on request) the policies related to various kinds of access to Digital Subjects <a href="http://spwiki.editme.com/ContextProvider#IContextR6">(R6 at http://spwiki.editme.com/ContextProvider)</a><br>
 * TODO: Provide access to the schema which governs the form of Digital Subjects in this context <a href="http://spwiki.editme.com/ContextProvider#IContextR7">(R7 at http://spwiki.editme.com/ContextProvider)</a><br>
 * TODO: Should there be a removeDigitalSubject method which takes a filter?
 * TODO: Add modify method(s)? Or perhaps modifications should happen on the IDigitalSubjects
 * 
 *
 */
public interface IContext
{
	/**
	 * Search for IDigitalSubject of given name.
	 * This is effectively the same as calling getDigitalSubjects(filter, attributeSelection) with
	 * the filter set to <appropriate filter for cuid=name><p>
	 * TODO: we need a way to present a properties constraint. This is to help providers which are gathering their data from expensive sources (i.e. ldap server). We don't want to cause multiple network hits, or extra data to be gathered.<br>
	 * TODO: discuss whether modifications to the returned IDigitalSubject affect the stored subject.<br>
	 * 
	 * @param cuid Contextually Unique ID of IDigitalSubject to find
	 * @return IDigitalSubject or null if not found
	 *
	 */
	public IDigitalSubject getDigitalSubject(String cuid);
	
	/**
	 * From this context, return IDigitalSubjects that match the specified filter <p>
	 * TODO: define filter format.<br>
	 * @param filter 	Filter used to constrain the set of IDigitalSubjects returned.
	 * 					A null or empty value causes all IDigitalSubjects to be returned.
	 * @param attributeSelection The attributes on IDigitalSubject objects which will be read by the caller. An empty set or null indicates that all attributes will be read.
	 * @return An Iterable object for IDigitalSubjects
	 *
	 */
	public Iterable<IDigitalSubject> getDigitalSubjects(String filter, Set<URI> attributeSelection);
	
	/**
	 * Adds an IDigitalSubject to this IContext.<p>
	 * TODO: specify an exception for name already exists.
	 * 
	 * @param ds IDigitalSubject to add to this IContext
	 * @return The IDigitalSubject added or null on failure
	 */
	public IDigitalSubject addDigitalSubject(IDigitalSubject ds);

	/**
	 * Removes an IDigitalSubject from this IContext. 
	 * 
	 * @param cuid Contextually Unique ID of IDigitalSubject to removed from this IContext
	 */
	public void removeDigitalSubject(String cuid);
	
}
