package test;

import java.util.List;
import java.util.stream.Collectors;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.interpreter.EGraph;
import org.eclipse.emf.henshin.interpreter.Engine;
import org.eclipse.emf.henshin.interpreter.UnitApplication;
import org.eclipse.emf.henshin.interpreter.impl.EGraphImpl;
import org.eclipse.emf.henshin.interpreter.impl.EngineImpl;
import org.eclipse.emf.henshin.interpreter.impl.UnitApplicationImpl;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;
import org.eclipse.emf.henshin.model.staticanalysis.PathFinder;


public class Reconstruct {

	public static final String PATH = "model";


	public static void run(String path) {

		// Create a resource set with a base directory:
		HenshinResourceSet resourceSet = new HenshinResourceSet(path);

		// Load the module:
		Module module = resourceSet.getModule("reconstruct.henshin", false);

		// Load the example model into an EGraph:
		EGraph graph = new EGraphImpl(resourceSet.getResource("reconstruct.xmi"));

		// Create an engine and a rule application:
		Engine engine = new EngineImpl();
		UnitApplication app = new UnitApplicationImpl(engine);
		app.setEGraph(graph);


		Rule rule = (Rule) module.getUnit("create");
		app.setUnit(rule);
		app.execute(null);

		try {
			rule = (Rule) module.getUnit("reconstruct");
			app.setUnit(rule);
			app.execute(null); // Throws NullPointerException
			
		} catch (NullPointerException e) {
			
			// The cause of the problem is located here.
			problemOrigin(rule.getMultiRules().get(0));
		}
	}

	public static void main(String[] args) {
		run(PATH);
	}


	public static void problemOrigin(Rule rule) {

		List<Node> collect = rule.getLhs().getNodes().stream().filter(node -> {
			EList<Attribute> attributes = node.getAttributes();

			if(attributes.isEmpty())
				return false;
			else {
				Attribute attribute = attributes.get(0);


				return ((String) attribute.getValue()).equals("\"Define\"") ||
						((String) attribute.getValue()).equals("\"Instances\"");
			}
		}).collect(Collectors.toList());

		PathFinder.findReferencePaths(collect.get(1), collect.get(0), true, true);
	}

}