import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.glu.GLU;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.part.ViewPart;

/*
 * Type:    .JOGL_Sun_TestView
 * File:  	JOGL_Sun_TestView.java
 * Project:	JOGL_Test_Sun
 * Date: 	Nov 12, 2008
 * Author: 	Jens von Pilgrim
 * Version:	$Revision$
 * Changed: $Date$ by $Author$ 
 *
 * Copyright 2006, FernUniversität in Hagen
 */

/**
 * JOGL_Sun_TestView
 * There should really be more documentation here.
 *
 * @author 	Jens von Pilgrim
 * @version	$Revision$
 * @since 	Nov 12, 2008
 * @log		
 *		$Log$
 */
public class JOGL_Sun_TestView extends ViewPart {

	/** The SWT GLCanvas */
	GLCanvas canvas;

	/** The JOGL GLContext */
	GLContext context;

	/** 

	 * {@inheritDoc}

	 * @see org.eclipse.ui.part.WorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)

	 */

	@Override
	public void createPartControl(Composite parent) {

		GLData data = new GLData();
		data.doubleBuffer = true;
		canvas = new GLCanvas(parent, SWT.NONE, data);
		canvas.setCurrent();

		context = GLDrawableFactory.getFactory().createExternalGLContext();

		canvas.addListener(SWT.Resize, new Listener() {

			public void handleEvent(Event event) {
				Rectangle bounds = canvas.getBounds();
				float fAspect = (float) bounds.width / (float) bounds.height;
				canvas.setCurrent();

				context.makeCurrent();
				GL gl = context.getGL();
				gl.glViewport(0, 0, bounds.width, bounds.height);

				gl.glMatrixMode(GL.GL_PROJECTION);
				gl.glLoadIdentity();

				GLU glu = new GLU();
				glu.gluPerspective(45.0f, fAspect, 0.5f, 400.0f);
				gl.glMatrixMode(GL.GL_MODELVIEW);
				gl.glLoadIdentity();
				context.release();
			}
		});

		context.makeCurrent();
		GL gl = context.getGL();
		gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
		gl.glColor3f(1.0f, 0.0f, 0.0f);
		gl.glHint(GL.GL_PERSPECTIVE_CORRECTION_HINT, GL.GL_NICEST);
		gl.glClearDepth(1.0);
		gl.glLineWidth(2);
		gl.glEnable(GL.GL_DEPTH_TEST);
		context.release();

		Display.getCurrent().asyncExec(initRunnable());

	}

	/** 

	 * {@inheritDoc}

	 * @see org.eclipse.ui.part.WorkbenchPart#setFocus()

	 */

	@Override
	public void setFocus() {

		canvas.setFocus();

	}

	static void drawTorus(GL gl, float r, float R, int nsides, int rings) {
		float ringDelta = 2.0f * (float) Math.PI / rings;
		float sideDelta = 2.0f * (float) Math.PI / nsides;
		float theta = 0.0f, cosTheta = 1.0f, sinTheta = 0.0f;
		for (int i = rings - 1; i >= 0; i--) {
			float theta1 = theta + ringDelta;
			float cosTheta1 = (float) Math.cos(theta1);
			float sinTheta1 = (float) Math.sin(theta1);
			gl.glBegin(GL.GL_QUAD_STRIP);
			float phi = 0.0f;
			for (int j = nsides; j >= 0; j--) {
				phi += sideDelta;
				float cosPhi = (float) Math.cos(phi);
				float sinPhi = (float) Math.sin(phi);
				float dist = R + r * cosPhi;
				gl.glNormal3f(cosTheta1 * cosPhi, -sinTheta1 * cosPhi, sinPhi);
				gl.glVertex3f(cosTheta1 * dist, -sinTheta1 * dist, r * sinPhi);
				gl.glNormal3f(cosTheta * cosPhi, -sinTheta * cosPhi, sinPhi);
				gl.glVertex3f(cosTheta * dist, -sinTheta * dist, r * sinPhi);
			}
			gl.glEnd();
			theta = theta1;
			cosTheta = cosTheta1;
			sinTheta = sinTheta1;
		}
	}

	static void showFPS(String str) {

	}

	static int count = 0;

	static long start = System.currentTimeMillis();

	static long end = 0;

	Runnable initRunnable() {

		return new Runnable() {
			int rot = 0;

			public void run() {
				if (!canvas.isDisposed()) {
					count++;
					canvas.setCurrent();
					context.makeCurrent();

					GL gl = context.getGL();
					gl.glClear(GL.GL_COLOR_BUFFER_BIT | GL.GL_DEPTH_BUFFER_BIT);
					gl.glClearColor(.3f, .5f, .8f, 1.0f);
					gl.glLoadIdentity();
					gl.glTranslatef(0.0f, 0.0f, -10.0f);
					float frot = rot;
					gl.glRotatef(0.15f * rot, 2.0f * frot, 10.0f * frot, 1.0f);
					gl.glRotatef(0.3f * rot, 3.0f * frot, 1.0f * frot, 1.0f);
					rot++;
					gl.glPolygonMode(GL.GL_FRONT_AND_BACK, GL.GL_LINE);
					gl.glColor3f(0.9f, 0.9f, 0.9f);
					drawTorus(gl, 1,
							1.9f + ((float) Math.sin((0.004f * frot))), 15, 15);

					canvas.swapBuffers();
					context.release();

					if (count % 100 == 0) {
						long end = System.currentTimeMillis();
						long ms = end - start;
						long fps = (count * 1000) / ms;
						System.err.println("fps: " + fps);
						count = 0;
						start = System.currentTimeMillis();
					}

					Display.getCurrent().asyncExec(this);
				}
			}
		};
	}

}
