package registry.test;

import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator implements BundleActivator {
    private final Object fMasterKey = new Object();
    private final Object fUserKey = new Object();
    private IExtensionRegistry fEclipseRegistry;
    private RegistryStrategy fRegistryStrategy; 

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
        fRegistryStrategy = RegistryFactory.createOSGiStrategy(null, null, fMasterKey);
        fEclipseRegistry = RegistryFactory.createRegistry(fRegistryStrategy, fMasterKey, fUserKey);
	}

	/*
	 * (non-Javadoc)
	 * @see org.osgi.framework.BundleActivator#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
        if (fEclipseRegistry != null) {
            fEclipseRegistry.stop(fMasterKey);
        }
	}

}
