<?php  																														require_once($_SERVER['DOCUMENT_ROOT'] . "/eclipse.org-common/system/app.class.php");	require_once($_SERVER['DOCUMENT_ROOT'] . "/eclipse.org-common/system/nav.class.php"); 	require_once($_SERVER['DOCUMENT_ROOT'] . "/eclipse.org-common/system/menu.class.php"); 	$App 	= new App();	$Nav	= new Nav();	$Menu 	= new Menu();		include($App->getProjectCommon());    # All on the same line to unclutter the user's desktop'

$pageTitle    = "Ecore Diagram Proposal";
$pageKeywords = "Modeling, Ecore, EMF, EMFT, GMF, Topcased";
$pageAuthor   = "David Sciamma";

ob_start();
?>
    <div id="maincontent">
	<div id="midcolumn">

<h1><img src="images/EcoreDiagramFile.gif"/>Ecore Diagram Proposal</h1>
</p>
<?php
include_once($_SERVER['DOCUMENT_ROOT'] . "/projects/fragments/proposal-page-header.php");
generate_header("YOUR PROPOSAL UNIQUE KEY HERE");
?>

<p>
Ecore Diagram is a proposed open source component under the Eclipse Modeling EMFT Project.
</p>

<p>
This proposal is in the Project Proposal Phase (as defined in the Eclipse Development Process document) and is written to declare its intent and scope.
This proposal is written to solicit additional participation and input from the Eclipse community.
You are invited to comment on and/or join the component.
Please send all feedback to the <a href="news://news.eclipse.org/eclipse.modeling.emft">Modeling EMFT newsgroup</a>.
</p>

<p>
The initial contribution pdf document is available <a img="images/pdf.gif" href="RFE/EcoreDiagramEditorRFE.pdf">[here]</a>.
</p>

<H4>Background</H4>

<p>
EMF can now be considered as de facto standard for Java Model Driven Software Development (MDSD) on Eclipse. Its large audience, counting significant Eclipse adopters project <i>(STP, TPTP, GMF, ...)</i> as well as major companies products <i>(Rational&reg; Software Architect, Rational&reg; Application Developer, Codegear&trade; JBuilder&reg; 2007, ...)</i> makes EMF Ecore community growing disruptively fast.
</p>

<p>
Open Source EMF Model Driven Development, now in an industrialization phase, mainly relies on EMF Ecore toolchain to leverage the MDA iterative development life cycle. However, as EMF based projects complexity and size increases, some productivity needs are emerging such as improving Ecore Diagraming user experience and to propose seamless integration with existing Ecore legacy tools.
</p>

<p>
For instance Eclipse platform offers powerful frameworks already specifically extended for Ecore like in EMF Search & EMF Compare components. Ecore Diagram component would take a major advantage to be integrated with these components as it would dramatically speed up the Ecore based tools development.
</p>

<p>
As a result, Ecore Diagram Editor would become a central place for Eclipse Ecore Developments, driving everytime it is possible existing Ecore integrations, as well as legacy toolchains. Following these directions would drive to deliver Ecore Diagram Editor with a dedicated Ecore perspective.
</p>

<p>
As Topcased open source modeling project contributors (Ecore, UML2, AADL, SysML modeling tools) and in an effort to mutualize development forces on EMF modeling space, we would like to contribute some of the existing Topcased productivity features to Eclipse modeling project.
Among these features, Ecore diagram editor & Ecore Tabbed Properties come as our top priorities.
</p>

<p>
This contribution will be the next step of a long term collaboration/merging strategy aiming to constantly improve Topcased core frameworks integration upon Modeling frameworks and tools.
</p>

<H4>Scope</H4>

<p>Ecore Diagram goals can be detailed in higher level specifications :</p>

<ul>
  <li> To Ease Ecore Editing
  <ul>
	<li>Rely on GMF based Diagram Editor</li>
	<li>Multi Diagram support</li>
	<li>Java Generics Aware (Tentative)</li>
	<li>Ecore Tabbed Properties</li>
  </ul>
  </li>
  <!--
  <li> To Organize Ecore Development Tool Chain
  <ul>
	<li>Ecore legacy tools Management (Codegen ?)</li>
	<li>Model to code, code to model navigations (tentative)
  </ul>
  </li>
  -->
  <li> To Integrate With Existing Ecore Tools
  <ul>
	<li>Compare</li>
	<li>Search</li>
	<li>Validation</li>
	<!--
	<li>OCL (tentative)</li>
  	-->
  </ul>
  </li>
  <!--
  <li> To Integrate With Existing Eclipse Tools
  <ul>
	<li>JDT (tentative)</li>
	<li>Mylyn (benefits ?)</li>
  </ul>
  </li>
  -->
  <li> A Foundation For A Basic Ecore MDD Environment
  <ul>
	<li>Ecore perspective organizing integrations</li>
  </ul>
  </li>
</ul>

<H4>Description</H4>

<p>Ecore Diagram , a focal point :</p>

<ul>
    <li>For Ecore based model driven development</li>
	<li>To define an Ecore meta-model based UI integration framework</li>
	<li>To be integrated with EMF Search</li>
	<li>To be integrated with EMF Compare</li>
	<li>To be integrated with EMF Validation</li>
	<!--
	<li>To be integrated with MDT OCL</li>
	<li>To be integrated with JDT (Tentative)</li>
	-->
</ul>

<H4>Organization</H4>
<p>
We propose sources under EPL for initial contribution, including customizable EMF tabbed propeties.
</p>
<p>
Ecore Diagram features are organized into different topics :
</p>
<ul>
	<li>GMF based editor</li>
	<li>EMF Tabbed Properties</li>
	<li>EMF Ecore Perspective</li>
	<li>EMF Search Integration</li>
	<li>EMF Validation Integration</li>
</ul>

<p>
The primary focus of the Ecore Diagram component will be on extensibility & robustness of basic features.
</p>

<H4>Contribution</H4>
<p>
Contribution will consist in an initial set of source plugins :
</p>

<p>
<a href="http://topcased-mm.gforge.enseeiht.fr/contribution/org.eclipse.emf.ecore.diagram.zip">[Plugins contribution archive]</a>
</p>

<ul>
  <li>org.eclipse.emf.ecore.diagram</li>
  <li>org.eclipse.emf.ecore.properties</li>
  <li>org.eclipse.emf.tabbedproperties</li>
  <li>org.eclipse.emf.ecore.diagram.search</li>
</ul>

<p>
With some EMF Search optional dependencies :
</p>
<ul>
  <li>org.eclipse.emf.search</li>
  <li>org.eclipse.emf.search.ecore</li>
  <li>org.eclipse.emf.search.ecore.ui</li>
  <li>org.eclipse.emf.search.ecore.common</li>
  <li>org.eclipse.emf.search.ecore.common.ui</li>
  <li>org.eclipse.emf.search.ui</li>
</ul>

<p>
And will certainly have some EMF Compare dependencies (TBD)
</p>
</ul>

</p>

<h4>Tentative Plan</h4>

<ul>
  <li>Initial Eclipse.org presence in Oct 2007
  <ul>
    <li>website
    <li>newsgroup
    <li>CVS repository, seeded with source code from current contribution
    <li>Bugzilla repository
  </ul>

  <li>v0.7: July 2008 synchronized with Ganymede Release
</ul>

<H4>Initial committers and contributors</H4>

<p>The initial committers will initially focus on providing an open, well documented API.  Our agile development process will follow eclipse.org's standards for openness and transparency.  Our goal is to provide the infrastructure and APIs needed to allow the integration/generation of additional model search engines.We also plan to help improve the Eclipse platform by submitting patches and extension point suggestions.</p>

The initial team will consist of several part-time resources:

<p><b>Component lead/Committer</b></p>
 	<ul style="list-style-type:square">
 	<li><a href="mailto:david.sciamma@anyware-tech.com">David Sciamma</a> - Anyware Technologies<br>
          <i>David is manager of the Eclipse development team and architect at Anyware Technologies. He is involved in the TOPCASED project since its beginning and designed the architecture of the TOPCASED Modeling Framework. He will be the leader of this new component : animation of the community, links with the Eclipse Foundation...</i>
        </li>
	</ul>

<p><b>Committers</b></p>
  <ul style="list-style-type:square">
    <li><a href="mailto:jacques.lescot@anyware-tech.com">Jacques Lescot</a> - Anyware Technologies<br>
      <i>Jacques is the main developer of the TOPCASED project. He acquired strong skills in Modeling, EMF, GEF and GMF. He will be in charge of the development the Ecore Diagram component and the interaction with other TOPCASED and Eclipse projects.</i>
    </li>
    <li><a href="mailto:gilles.cannenterre@anyware-tech.com">Gilles Cannenterre</a> - Anyware Technologies<br>
      <i>Gilles developed the first version of the Ecore Diagram using GMF. He will participate in development and design of the final release.</i>
    </li>
  </ul>

<H4>Interested parties</H4>

<p>
EMF MDD/Modeling community is obviously the main target and audience for this component.
We are expecting and will actively pursue during the proposal and incubation phases, active participation.
</p>
  <ul style="list-style-type:square">
    <li>TOPCASED Partners :
    <ul>
      <li>Airbus</li>
      <li>Astrium</li>
      <li>CNES</li>
      <li>Siemens VDO</li>
      <li>Thal&egrave;s</li>
      <li>...</li>
    </ul>
    </li>
    <li>IBM</li>
  </ul>

<H4>User community</H4>

<p>
The existing Modeling developer/user community will be the primary user base. This includes an important presence in academia since Eclipse/EMF is frequently used in programming courses.
</p>

<H4>Links</H4>

<a href="http://www.eclipse.org/modeling">[Eclipse modeling project]</a><BR>
<a href="http://www.topcased.org">[Topcased project]</a><BR>
<a href="http://www.anyware-technologies.com">[Anyware Technologies]</a><BR>
<br>

      </div>
  </div>
<?php
	$html = ob_get_contents();
	ob_end_clean();

	# Generate the web page
	$App->generatePage($theme, $Menu, $Nav, $pageAuthor, $pageKeywords, $pageTitle, $html);
?>
