/*******************************************************************************
 * Copyright (c) 2008 Wind River Systems, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Martin Oberhuber (Wind River) - initial API and implementation
 *******************************************************************************/

package org.eclipse.fstest;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.attribute.AclFileAttributeView;
import java.util.Map;

/**
 * Testing some Java7 / JSR203 file system operations on Windows
 */
public class FSTest {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		FileSystem localFS = FileSystems.getDefault();
		Path p1 = localFS.getPath("C:\\Program Files");
		Path p2 = localFS.getPath("C:\\PROGRA~1");
		Path p3 = localFS.getPath("c:\\Progra~1");

		// 1. Checking Path.isSameFile()
		try {
			if (p1.isSameFile(p2)) {
				System.out.println("Same!");
			}
		} catch (IOException ioe) {
			System.err.println("Error on isSameFile: " + ioe);
		}

		// 2. Checking URI, and toRealPath() vs getCanonicalPath()
		URI p2URI = p2.toAbsolutePath().toUri();
		System.out.println("p2URI: " + p2URI);
		try {
			System.out.println("realpath: " + p2.toRealPath(true));
			System.out.println("canonical: " + new File(p2URI).getCanonicalPath());
		} catch (IOException ioe) {
			System.err.println("Error on toRealPath: " + ioe);
		}

		// 3. Checking Path.compareTo
		System.out.println("compareTo: " + p2.compareTo(p3));

		// 4. Checking File Attribute Views and ACLs
		AclFileAttributeView v = (AclFileAttributeView) p1.getFileAttributeView(AclFileAttributeView.class, true);
		try {
			Map m = v.readAttributes("*");
			System.out.println("attrs: " + m);
		} catch (IOException ioe) {
			System.err.println("Error on readAttributes: " + ioe);
		}
	}

}
