/*******************************************************************************
 * Copyright (c) 2004 Composent, Inc. All rights reserved. This
 * program and the accompanying materials are made available under the terms of
 * the Eclipse Public License v1.0 which accompanies this distribution, and is
 * available at http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Composent, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.ecf.filetransfer.events;

import java.io.File;

import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;

/**
 * Event to represent remote file transfer requests
 * 
 */
public interface IFileTransferRequestEvent extends IFileTransferEvent {
	/**
	 * Get ID of remote requester
	 * 
	 * @return ID of remote requester
	 */
	public ID getRequesterID();

	/**
	 * Get file transfer info associated with this file transfer request even
	 * 
	 * @return IFileTransfer info. Will not return null.
	 */
	public IFileTransferInfo getFileTransferInfo();

	/**
	 * Accept the file transfer request. This method should be called if the
	 * receiver of the IFileTransferRequestEvent would like to accept the file
	 * transfer request. Will not return null
	 * 
	 * @param localFileToSave
	 *            the file on the local file system to receive the remote file
	 * @return IIncomingFileTransfer to receive file
	 * @throws IncomingFileTransferException
	 *             if accept message cannot be delivered back to requester
	 */
	public IIncomingFileTransfer accept(File localFileToSave)
			throws IncomingFileTransferException;

	/**
	 * Reject the file transfer request. This method should be called if the
	 * receiver of the IFileTransferRequestEvent would like to reject the file
	 * transfer request
	 * 
	 */
	public void reject();

	/**
	 * If request was accepted from remote target this method will return true,
	 * if rejected or failed returns false.
	 * 
	 * @return true if request was accepted, false if rejected or failed
	 */
	public boolean requestAccepted();
}
